package com.ejianc.business.jltest.margin.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.jltest.orgtest.vo.PlaneDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 人员缴纳总台账
 *
 * @author generator
 */
public class EmployeeBillVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // billcode
    private String phone; // 联系方式
    private BigDecimal paidMny; // 累计缴纳金额
    private BigDecimal refundMny; // 累计退还金额
    private BigDecimal actualPaidMny; // 实际缴纳金额
    private BigDecimal allotmentMny; // 累计分配金额
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）

    private List<PaymentDetailsVO> paymentDetailsList = new ArrayList<>(); // 风险金缴纳记录

    private List<InspiritLossVO> inspiritLossList = new ArrayList<>(); // 激励/补亏分配详情记录

    private List<PaymentRecordVO> paymentRecordList = new ArrayList<>(); // 缴纳记录




    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public BigDecimal getPaidMny() {
        return paidMny;
    }

    public void setPaidMny(BigDecimal paidMny) {
        this.paidMny = paidMny;
    }

    public BigDecimal getRefundMny() {
        return refundMny;
    }

    public void setRefundMny(BigDecimal refundMny) {
        this.refundMny = refundMny;
    }

    public BigDecimal getActualPaidMny() {
        return actualPaidMny;
    }

    public void setActualPaidMny(BigDecimal actualPaidMny) {
        this.actualPaidMny = actualPaidMny;
    }

    public BigDecimal getAllotmentMny() {
        return allotmentMny;
    }

    public void setAllotmentMny(BigDecimal allotmentMny) {
        this.allotmentMny = allotmentMny;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<PaymentDetailsVO> getPaymentDetailsList() {
        return paymentDetailsList;
    }

    public void setPaymentDetailsList(List<PaymentDetailsVO> paymentDetailsList) {
        this.paymentDetailsList = paymentDetailsList;
    }

    public List<InspiritLossVO> getInspiritLossList() {
        return inspiritLossList;
    }

    public void setInspiritLossList(List<InspiritLossVO> inspiritLossList) {
        this.inspiritLossList = inspiritLossList;
    }

    public List<PaymentRecordVO> getPaymentRecordList() {
        return paymentRecordList;
    }

    public void setPaymentRecordList(List<PaymentRecordVO> paymentRecordList) {
        this.paymentRecordList = paymentRecordList;
    }
}
