package com.ejianc.business.jltest.orgtest.api;

import com.ejianc.business.jltest.orgtest.hystrix.IMeetingHystrix;
import com.ejianc.business.jltest.orgtest.vo.MeetingVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(
        name = "ejc-jltest-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-jltest-web",
        fallback = IMeetingHystrix.class
)
public interface IMeetingApi {

    /**
     * 根据明细id 获取单据详情
     *
     */
    @RequestMapping(
            value = {"/api/meeting/queryMeetingByDetailId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<MeetingVO> queryMeetingByDetailId(@RequestParam("detailId") Long detailId);


}
