package com.ejianc.business.jltest.orgtest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.orgtest.vo.DangerdDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 重大事故隐患判定D
 * 
 * @author generator
 * 
 */
public class DangerdVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 重大事故隐患判定字号
    private String dangerName; // 重大事故隐患判定名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date selfCheckDate; // 自查日期
    private BigDecimal proposedInvestmentMny; // 拟投入金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer genType; // 单据产生类型 1-自动生成 2-手填
    private String memo; // 备注
    private Long projectId; // 项目
    private String projectName; // 
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 
    private String orgCode; // 组织code
    private String parentOrgName; // 
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<DangerdDetailVO> dangerdDetailList = new ArrayList<>(); // 重大事故隐患判定明细D

    public Integer getGenType() {
        return genType;
    }

    public void setGenType(Integer genType) {
        this.genType = genType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getDangerName() {
        return dangerName;
    }

    public void setDangerName(String dangerName) {
        this.dangerName = dangerName;
    }
    public Date getSelfCheckDate() {
        return selfCheckDate;
    }

    public void setSelfCheckDate(Date selfCheckDate) {
        this.selfCheckDate = selfCheckDate;
    }
    public BigDecimal getProposedInvestmentMny() {
        return proposedInvestmentMny;
    }

    public void setProposedInvestmentMny(BigDecimal proposedInvestmentMny) {
        this.proposedInvestmentMny = proposedInvestmentMny;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<DangerdDetailVO> getDangerdDetailList() {
        return dangerdDetailList;
     }

     public void setDangerdDetailList(List<DangerdDetailVO> dangerdDetailList) {
        this.dangerdDetailList = dangerdDetailList;
     }
}
