package com.ejianc.job.admin.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.job.admin.hystrix.JobAdminHystrix;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(name = "ejc-job-admin", url = "${common.env.feign-client-url}", path = "ejc-job-admin", fallback = JobAdminHystrix.class)
public interface IJobAdminApi {
    /**
     * 新增调度任务
     *
     * @return
     */
    @PostMapping("api/jobinfo/add")
    @ResponseBody
    CommonResponse<XxlJobInfo> add(@RequestBody XxlJobInfo jobInfo);

    /**
     * 修改调度任务
     *
     * @return
     */
    @PostMapping("api/jobinfo/update")
    @ResponseBody
    CommonResponse<String> update(@RequestBody XxlJobInfo jobInfo);

    /**
     * 执行一次调度任务
     *
     * @return
     */
    @GetMapping("api/jobinfo/triggerJob")
    @ResponseBody
    CommonResponse<String> triggerJob(@RequestParam int id,@RequestParam String executorParam);

    /**
     * 查询一条调度任务
     *
     * @return
     */
    @GetMapping("api/jobinfo/queryOne")
    @ResponseBody
    CommonResponse<XxlJobInfo> queryOne(@RequestParam Integer id);

    /**
     * 删除调度任务
     *
     * @return
     */
    @GetMapping("api/jobinfo/remove")
    @ResponseBody
    CommonResponse<String> remove(@RequestParam Integer id);

    /**
     * 启动调度任务
     *
     * @return
     */
    @GetMapping("api/jobinfo/start")
    @ResponseBody
    CommonResponse<String> start(@RequestParam Integer id);

    /**
     * 停止调度任务
     *
     * @return
     */
    @GetMapping("api/jobinfo/stop")
    @ResponseBody
    CommonResponse<String> stop(@RequestParam Integer id);

    /**
     * 新增调度任务执行器
     *
     * @return
     */
    @PostMapping("api/jobinfo/addGroup")
    @ResponseBody
    CommonResponse<XxlJobGroup> addGroup(@RequestBody XxlJobGroup group);

    /**
     * 更新调度任务执行器
     *
     * @return
     */
    @PostMapping("api/jobinfo/updateGroup")
    @ResponseBody
    CommonResponse<String> updateGroup(@RequestBody XxlJobGroup group);

    /**
     * 查询执行器列表
     *
     * @return
     */
    @GetMapping("api/jobinfo/queryGroupList")
    @ResponseBody
    CommonResponse<List<XxlJobGroup>> queryGroupList();

    /**
     * 删除执行器
     *
     * @return
     */
    @GetMapping("api/jobinfo/removeGroup")
    @ResponseBody
    CommonResponse<String> removeGroup(@RequestParam Integer id);

    /**
     * 分页查询调度任务日志
     * filterTime 格式：2020-01-01 00:00:00,2020-01-01 23:59:59
     * @return
     */
    @GetMapping("api/jobinfo/pageLogList")
    @ResponseBody
    CommonResponse<Page<XxlJobLog>> pageLogList(@RequestParam(required = false, defaultValue = "1") int pageIndex,
                                                @RequestParam(required = false, defaultValue = "10") int pageSize,
                                                @RequestParam int jobGroup,
                                                @RequestParam int jobId,
                                                @RequestParam int logStatus,
                                                @RequestParam(required = false) String filterTime);

    /**
     * 查询执行日志详情
     *
     * @param executorAddress 执行器地址
     * @param triggerTime     触发时间
     * @param logId           日志ID
     * @param fromLineNum     从行数
     * @return
     */
    @RequestMapping("api/jobinfo/logDetailCat")
    @ResponseBody
    CommonResponse<String> logDetailCat(@RequestParam String executorAddress,
                                        @RequestParam long triggerTime,
                                        @RequestParam int logId,
                                        @RequestParam int fromLineNum);

    /**
     * 获取调度任务统计信息
     *
     * @return
     */
    @RequestMapping("api/jobinfo/dashboardInfo")
    @ResponseBody
    CommonResponse<Map<String,Object>> dashboardInfo();

    /**
     * 获取调度任务统计信息
     *
     * @return
     */
    @RequestMapping("api/jobinfo/pieAndBarInfo")
    @ResponseBody
    CommonResponse<Map<String,Object>> pieAndBarInfo(@RequestParam String startDateStr,@RequestParam String endDateStr);
}
