/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobRegistry;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.RegistryConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobgroup"})
public class JobGroupController {
    @Value(value="${database.dbtype:mysql}")
    private String dbType;
    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;

    @RequestMapping
    public String index(Model model) {
        List<XxlJobGroup> list = this.xxlJobGroupDao.findAll();
        model.addAttribute("list", list);
        return "jobgroup/jobgroup.index";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ReturnT<String> save(XxlJobGroup xxlJobGroup) {
        int ret;
        if (xxlJobGroup.getAppName() == null || xxlJobGroup.getAppName().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "AppName");
        }
        if (xxlJobGroup.getAppName().length() < 4 || xxlJobGroup.getAppName().length() > 64) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_field_appName_length"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
        }
        if (xxlJobGroup.getAddressType() != 0) {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        return (ret = this.xxlJobGroupDao.save(xxlJobGroup)) > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public ReturnT<String> update(XxlJobGroup xxlJobGroup) {
        if (xxlJobGroup.getAppName() == null || xxlJobGroup.getAppName().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "AppName");
        }
        if (xxlJobGroup.getAppName().length() < 4 || xxlJobGroup.getAppName().length() > 64) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_field_appName_length"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
        }
        if (xxlJobGroup.getAddressType() == 0) {
            List<String> registryList = this.findRegistryByAppName(xxlJobGroup.getAppName());
            String addressListStr = null;
            if (registryList != null && !registryList.isEmpty()) {
                Collections.sort(registryList);
                addressListStr = "";
                for (String item : registryList) {
                    addressListStr = addressListStr + item + ",";
                }
                addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
            }
            xxlJobGroup.setAddressList(addressListStr);
        } else {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        int ret = this.xxlJobGroupDao.update(xxlJobGroup);
        return ret > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    private List<String> findRegistryByAppName(String appNameParam) {
        HashMap appAddressMap = new HashMap();
        List<XxlJobRegistry> list = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().findAll(90, this.dbType);
        if (list != null) {
            for (XxlJobRegistry item : list) {
                if (!RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) continue;
                String appName = item.getRegistryKey();
                ArrayList<String> registryList = (ArrayList<String>)appAddressMap.get(appName);
                if (registryList == null) {
                    registryList = new ArrayList<String>();
                }
                if (!registryList.contains(item.getRegistryValue())) {
                    registryList.add(item.getRegistryValue());
                }
                appAddressMap.put(appName, registryList);
            }
        }
        return (List)appAddressMap.get(appNameParam);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ReturnT<String> remove(int id) {
        int count = this.xxlJobInfoDao.pageListCount(0, 10, id, null, null);
        if (count > 0) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_del_limit_0"));
        }
        List<XxlJobGroup> allList = this.xxlJobGroupDao.findAll();
        if (allList.size() == 1) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_del_limit_1"));
        }
        int ret = this.xxlJobGroupDao.remove(id);
        return ret > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }
}

