/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller.interceptor;

import com.xxl.job.admin.controller.annotation.PermessionLimit;
import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.util.CookieUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PermissionInterceptor
extends HandlerInterceptorAdapter {
    public static final String LOGIN_IDENTITY_KEY = "XXL_JOB_LOGIN_IDENTITY";
    private static String LOGIN_IDENTITY_TOKEN;

    public static String getLoginIdentityToken() {
        if (LOGIN_IDENTITY_TOKEN == null) {
            String username = XxlJobAdminConfig.getAdminConfig().getLoginUsername();
            String password = XxlJobAdminConfig.getAdminConfig().getLoginPassword();
            String tokenTmp = DigestUtils.md5DigestAsHex((byte[])String.valueOf(username + "_" + password).getBytes());
            LOGIN_IDENTITY_TOKEN = tokenTmp = new BigInteger(1, tokenTmp.getBytes()).toString(16);
        }
        return LOGIN_IDENTITY_TOKEN;
    }

    public static boolean login(HttpServletResponse response, String username, String password, boolean ifRemember) {
        String tokenTmp = DigestUtils.md5DigestAsHex((byte[])String.valueOf(username + "_" + password).getBytes());
        tokenTmp = new BigInteger(1, tokenTmp.getBytes()).toString(16);
        if (!PermissionInterceptor.getLoginIdentityToken().equals(tokenTmp)) {
            return false;
        }
        CookieUtil.set(response, LOGIN_IDENTITY_KEY, PermissionInterceptor.getLoginIdentityToken(), ifRemember);
        return true;
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.remove(request, response, LOGIN_IDENTITY_KEY);
    }

    public static boolean ifLogin(HttpServletRequest request) {
        String indentityInfo = CookieUtil.getValue(request, LOGIN_IDENTITY_KEY);
        return indentityInfo != null && PermissionInterceptor.getLoginIdentityToken().equals(indentityInfo.trim());
    }

    public List<String> excludeConfig() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add("/jobinfo/webinsert");
        return resultList;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod method;
        PermessionLimit permission;
        String requestUri = request.getRequestURI();
        List<String> excludeUrls = this.excludeConfig();
        boolean isExclude = false;
        for (String pattern : excludeUrls) {
            if (requestUri.indexOf(pattern) == -1) continue;
            isExclude = true;
            break;
        }
        if (isExclude) {
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            return super.preHandle(request, response, handler);
        }
        if (!PermissionInterceptor.ifLogin(request) && ((permission = (PermessionLimit)(method = (HandlerMethod)handler).getMethodAnnotation(PermessionLimit.class)) == null || permission.limit())) {
            response.sendRedirect(request.getContextPath() + "/toLogin");
            return false;
        }
        return super.preHandle(request, response, handler);
    }
}

