package com.ejianc.business.labor.api;

import com.ejianc.business.labor.hystrix.AttendanceHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name= "ejc-labor-web", url="${common.env.feign-client-url}", path="ejc-labor-web", fallback = AttendanceHystrix.class)
public interface IAttendanceApi {
    /**
     * 根据项目加区间，查询考勤记录数量
     *
     * @return
     */
    @GetMapping({"/api/attendance/queryNumByProjAndQj"})
    CommonResponse<Integer> queryNumByProjAndQj(@RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate, @RequestParam("projectId") Long projectId);
}
