package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.labor.vo.OvertimeApplyDetailVO;

/**
 * 加班申请
 * 
 * @author generator
 * 
 */
@ApiModel("加班申请")
public class OvertimeApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("项目名称")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织")
    private String orgName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    @ApiModelProperty("申请说明")
    private String memo;
    
    @ApiModelProperty("加班申请明细")
    private List<OvertimeApplyDetailVO> detailList = new ArrayList<>();


    private String  billStateStr;

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织d
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织d
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 申请日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 申请日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 申请说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 申请说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<OvertimeApplyDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OvertimeApplyDetailVO> detailList) {
        this.detailList = detailList;
    }
}
