package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labor.vo.SalaryDetailVO;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
public class SalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date salaryMonth; // 工资月份
    private Integer laborType; // 劳务类型
    private String laborTypeName; // 劳务类型名称
    private Long orgId; // 所属组织d
    private String orgName; // 所属组织
    private BigDecimal shouldSalaryMny; // 应发工资金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 办理日期
    private String memo; //  备注
    
    private List<SalaryDetailVO> salaryDetailList = new ArrayList<>(); // 劳务工资单-用工记录

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getSalaryMonth() {
        return salaryMonth;
    }

    public void setSalaryMonth(Date salaryMonth) {
        this.salaryMonth = salaryMonth;
    }
    public Integer getLaborType() {
        return laborType;
    }

    public void setLaborType(Integer laborType) {
        this.laborType = laborType;
    }
    public String getLaborTypeName() {
        return laborTypeName;
    }

    public void setLaborTypeName(String laborTypeName) {
        this.laborTypeName = laborTypeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<SalaryDetailVO> getSalaryDetailList() {
        return salaryDetailList;
     }

     public void setSalaryDetailList(List<SalaryDetailVO> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
     }
}
