package com.ejianc.business.labor.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: 劳务工人信息常量
 * @author songlx
 * @date 2022/11/22
 * @version 1.0
 */
public class WorkerConsts {


    /**
     *  0-待校验，1-是，2-否，3-异常
     *  身份证照片： 1、是：存在身份证信息页，且校验是正确的身份证；2、否：不存在身份证信息页；3、异常：存在身份证信息页，但是校验不通过；4、待校验：照片传上去后，还未校验。
     *
     *  人脸采集： 1、是：存在人脸照片，且校验照片中有人脸；2、否：不存在人脸照片；3、异常：存在人脸照片，但是校验不通过；4、待校验：照片传上去后，还未校验。
     */
    public enum ValidateEnum {

        待校验(0, "待校验"),
        是(1, "是"),
        否(2, "否"),
        异常(3, "异常");

        private Integer code;

        private String name;

        private static Map<Integer, String> enumMap = new HashMap();

        static {
            enumMap = EnumSet.allOf(ValidateEnum.class).stream().collect(Collectors.toMap(ValidateEnum::getCode, ValidateEnum::getName));
        }

        public static String getNameByCode(Integer code) {
            return enumMap.get(code);
        }

        ValidateEnum(Integer code, String description) {
            this.code = code;
            this.name = description;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }


    /**
     *  1-男，2-女
     */
    public enum SexEnum {

        女(2, "女"),
        男(1, "男");

        private Integer code;

        private String name;

        private static Map<Integer, String> enumMap = new HashMap();

        static {
            enumMap = EnumSet.allOf(SexEnum.class).stream().collect(Collectors.toMap(SexEnum::getCode, SexEnum::getName));
        }

        public static String getNameByCode(Integer code) {
            return enumMap.get(code);
        }

        SexEnum(Integer code, String description) {
            this.code = code;
            this.name = description;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    /**
     *  1:启用/0:停用
     */
    public enum EnabledEnum {

        停用(0, "停用"),
        启用(1, "启用");

        private Integer code;

        private String name;

        private static Map<Integer, String> enumMap = new HashMap();

        static {
            enumMap = EnumSet.allOf(EnabledEnum.class).stream().collect(Collectors.toMap(EnabledEnum::getCode, EnabledEnum::getName));
        }

        public static String getNameByCode(Integer code) {
            return enumMap.get(code);
        }

        EnabledEnum(Integer code, String description) {
            this.code = code;
            this.name = description;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    /**
     *  来源：1-公司自制，2-项目进场
     */
    public enum SourceFlagEnum {

        公司自制(1, "公司自制");

        private Integer code;

        private String name;

        private static Map<Integer, String> enumMap = new HashMap();

        static {
            enumMap = EnumSet.allOf(SourceFlagEnum.class).stream().collect(Collectors.toMap(SourceFlagEnum::getCode, SourceFlagEnum::getName));
        }

        public static String getNameByCode(Integer code) {
            return enumMap.get(code);
        }

        SourceFlagEnum(Integer code, String description) {
            this.code = code;
            this.name = description;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }


    /**
     *  用工状态：0未入场，1已入场
     */
    public enum WorkStateEnum {

        未入场(0, "未入场"),
        已入场(1, "已入场");

        private Integer code;

        private String name;

        private static Map<Integer, String> enumMap = new HashMap();

        static {
            enumMap = EnumSet.allOf(WorkStateEnum.class).stream().collect(Collectors.toMap(WorkStateEnum::getCode, WorkStateEnum::getName));
        }

        public static String getNameByCode(Integer code) {
            return enumMap.get(code);
        }

        WorkStateEnum(Integer code, String description) {
            this.code = code;
            this.name = description;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

}
