package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务工资申请-工资详情
 * 
 * @author generator
 * 
 */
public class PayApplySalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long payapplyId; // 付款申请主键ID
    private String salaryBillCode; // 工资单单据编号
    private Long salaryBillId; // 工资单ID
    private Long salaryId; // 工资条ID
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date salaryMonth; // 工资月份
    private Long workerId; // 工人id
    private String workerName; // 工人姓名
    private Integer sex; // 性別 1:男 2:女
    private String phone; // 手机号
    private String idCard; // 身份证号码
    private String teamId; // 班组id
    private String teamName; // 班组名称
    private String workType; // 工种id
    private String workTypeName; // 工种名称
    private String bankCard; // 银行卡号
    private String bankName; // 开户行
    private BigDecimal shouldSalaryMny; // 应发工资:工作量*单价+加班工作量*单价
    private BigDecimal alreadyApplyMny; // 已经申请金额
    private BigDecimal surplusMny; // 剩余可申请金额
    private BigDecimal applyMny; // 本期申请金额
    private String memo; // 备注
    private String createUserName; // 创建者名称
    

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public String getSalaryBillCode() {
        return salaryBillCode;
    }

    public void setSalaryBillCode(String salaryBillCode) {
        this.salaryBillCode = salaryBillCode;
    }
    public Long getSalaryBillId() {
        return salaryBillId;
    }

    public void setSalaryBillId(Long salaryBillId) {
        this.salaryBillId = salaryBillId;
    }
    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }
    public Date getSalaryMonth() {
        return salaryMonth;
    }

    public void setSalaryMonth(Date salaryMonth) {
        this.salaryMonth = salaryMonth;
    }
    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    @ReferSerialTransfer(referCode = "projectTeamRef")
    public String getTeamId() {
        return teamId;
    }

    @ReferDeserialTransfer
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getWorkType() {
        return workType;
    }

    @ReferDeserialTransfer
    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }
    public BigDecimal getAlreadyApplyMny() {
        return alreadyApplyMny;
    }

    public void setAlreadyApplyMny(BigDecimal alreadyApplyMny) {
        this.alreadyApplyMny = alreadyApplyMny;
    }
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    
}
