package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labor.vo.PayApplySalaryVO;
import com.ejianc.business.labor.vo.PayApplySummaryVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务工资申请
 * 
 * @author generator
 * 
 */
public class PayApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间
    private String memo; // 备注
    private Integer payType; // 付款类型：1-组织付款 2-项目付款
    private Integer payStatus; // 支付状态：1-未支付 2-已支付
    private BigDecimal payMny; // 支付金额
    private Long contractId; // 合同主键
    private Long contractType; // 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectShortName; // 项目简称
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String projectType; // 项目类型：1-自营，2-联营
    private String projectTypeName; // 项目类型名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long feeType; // 支付属性：1-预付款，2-过程款，3-其他
    private Long feeKind; // 支付类型
    private String feeKindName; // 支付类型
    private String payReason; // 付款事由
    private Long payUnitId; // 付款单位
    private String payUnitName; // 付款单位名称
    private Long receiveUnitId; // 收款单位
    private String receiveUnitName; // 收款单位名称
    private BigDecimal contractMny; // 合同金额
    private BigDecimal sumSettleMny; // 已结算金额
    private BigDecimal sumPayMny; // 累计已付
    private BigDecimal sumApplyMny; // 截止上期已申请
    private BigDecimal sumInvoiceMny; // 已收票金额
    private Long applyUserId; // 申请人
    private String applyUserName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime; // 申请时间
    private BigDecimal applyMny; // 申请金额
    private String applyMnyCn; // 申请金额大写
    private BigDecimal sumSurplusApplyMny; // 剩余申请金额
    private String accountName; // 账户名称
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private BigDecimal invoiceMny; // 发票金额
    private String backReason; // 撤回原因
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime; // 撤回时间
    private BigDecimal payScale; // 合同支付比例
    private BigDecimal bePayScale; // 已支付比例
    private BigDecimal endthisPayScale; // 截止本期申请比例（按结算）
    private BigDecimal collectRatio; // 对甲回款比例
    private BigDecimal sumCollectMny; // 项目收款总额
    private BigDecimal sumProductionTaxMny; // 累计完成产值
    private BigDecimal endthisPayScaleByContract; // 截止本期申请比例（按合同）
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime; // 审批时间
    private String purchaseType; // 采购类型 1-自采，2-集采
    private String dependOnProject; // 属于项目:1-是，0-否
    private String invoiceFlag; // 是否需要发票：1-需要，2-不需要，3-不确定
    private Long contractStageId; // 合同付款阶段id
    private BigDecimal contractStageScale; // 合同付款阶段比例
    private String contractStageName; // 合同付款阶段名称
    private BigDecimal proContractMny; // 收入合同金额
    private BigDecimal proOutputMny; // 完成产值
    private BigDecimal proDateProgress; // 日期进度
    private BigDecimal proOutputProgress; // 产值进度
    private BigDecimal proContractReceiveMny; // 合同累计收款金额
    private BigDecimal proReceiveMny; // 累计收款
    private BigDecimal proPayMny; // 累计付款
    private BigDecimal proCostListSurplus; // 费用清单结余
    private BigDecimal proTransferSurplus; // 项目代转款款结余
    private BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private BigDecimal proLoanBalance; // 借款结余
    private BigDecimal proLoanInterest; // 借款利息
    private BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private BigDecimal proOtherFeeBack; // 其他费用退还
    private BigDecimal proSurplusMny; // 项目可用资金
    private BigDecimal proSurplusApplyMny; // 剩余可申请金额
    private BigDecimal proPettyCash; // 备用金结余
    private BigDecimal proManageScale; // 管理费比例
    private BigDecimal proManageFee; // 管理费
    private BigDecimal proAmerce; // 罚款
    private BigDecimal proApplyUnpayMny; // 已申请未支付金额
    private BigDecimal curPenaltyMoney; // 本期扣款金额合计
    private BigDecimal curSettleMoney; // 本期结算金额合计
    private BigDecimal curContractPayMoney; // 本期合同应付金额合计
    private Integer paymentType; // 世纪阳光专用 付款类型：1-保温，2-饰面，3-自有劳务
    private String incomeCode; // 施工合同编号
    private BigDecimal waitDeductMny; // 待扣金额
    private Integer salaryFlag; // 是否是工人工资：0-否，1-是
    private Long applyType; // 劳务工资申请-申请类型
    private String applyTypeName; // 劳务工资申请-申请类型名称
    private BigDecimal sumContractSalary; // 累计合同工资
    private BigDecimal totalApplyMny; // 累计已申请金额
    private String payAccountName; // 付款账户名
    private String payAccountNum; // 付款银行账号
    private String payAccountBank; // 付款开户行
    private Long payWay; // 付款方式
    private String payWayName; // 付款方式名称
    private BigDecimal applyMnyBeforeClose; // 关闭前的本期申请金额
    private Integer closeFlag; // 是否关闭(0-否，1-是)
    private String closeState; // 关闭状态
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date closeTime; // 关闭时间
    private String closeUser; // 关闭人
    private Integer contractTypeExtend; // 合同类型扩展：0-劳务分包,1-专业分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
    private Long subContractType; // 分包合同类型
    private Long othContractType; // 其他支出合同合同类型
    private String othContractTypeName; // 其他支出合同合同类型名称
    private Integer receiveInvoiceFlag; // 确认收票标识：1-未确认收票，2-已确认
    private Long customerId; // 客户id
    private String customerName; // 客户名称
    private BigDecimal totalApplyLaborMny; // 本次申请人工费金额合计
    private BigDecimal shouldPayLaborMny; // 开累应付人工费金额
    private BigDecimal sumPayLaborMny; // 累计已付人工费
    private BigDecimal payLaborMny; // 本单据已支付人工费
    
    private List<PayApplySalaryVO> salaryList = new ArrayList<>(); // 劳务工资申请-工资详情
    private List<PayApplySummaryVO> summaryList = new ArrayList<>(); // 劳务工资申请-工资汇总

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectShortName() {
        return projectShortName;
    }

    public void setProjectShortName(String projectShortName) {
        this.projectShortName = projectShortName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeKind() {
        return feeKind;
    }

    @ReferDeserialTransfer
    public void setFeeKind(Long feeKind) {
        this.feeKind = feeKind;
    }

    public String getFeeKindName() {
        return feeKindName;
    }

    public void setFeeKindName(String feeKindName) {
        this.feeKindName = feeKindName;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }

    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }
    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public BigDecimal getSumSurplusApplyMny() {
        return sumSurplusApplyMny;
    }

    public void setSumSurplusApplyMny(BigDecimal sumSurplusApplyMny) {
        this.sumSurplusApplyMny = sumSurplusApplyMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public BigDecimal getBePayScale() {
        return bePayScale;
    }

    public void setBePayScale(BigDecimal bePayScale) {
        this.bePayScale = bePayScale;
    }
    public BigDecimal getEndthisPayScale() {
        return endthisPayScale;
    }

    public void setEndthisPayScale(BigDecimal endthisPayScale) {
        this.endthisPayScale = endthisPayScale;
    }
    public BigDecimal getCollectRatio() {
        return collectRatio;
    }

    public void setCollectRatio(BigDecimal collectRatio) {
        this.collectRatio = collectRatio;
    }
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getEndthisPayScaleByContract() {
        return endthisPayScaleByContract;
    }

    public void setEndthisPayScaleByContract(BigDecimal endthisPayScaleByContract) {
        this.endthisPayScaleByContract = endthisPayScaleByContract;
    }
    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }
    public BigDecimal getContractStageScale() {
        return contractStageScale;
    }

    public void setContractStageScale(BigDecimal contractStageScale) {
        this.contractStageScale = contractStageScale;
    }
    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }
    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }
    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }
    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }
    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }
    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }
    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }
    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }
    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }
    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }
    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }
    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }
    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }
    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }
    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }
    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }
    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }
    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }
    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }
    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }
    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }
    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }
    public BigDecimal getCurPenaltyMoney() {
        return curPenaltyMoney;
    }

    public void setCurPenaltyMoney(BigDecimal curPenaltyMoney) {
        this.curPenaltyMoney = curPenaltyMoney;
    }
    public BigDecimal getCurSettleMoney() {
        return curSettleMoney;
    }

    public void setCurSettleMoney(BigDecimal curSettleMoney) {
        this.curSettleMoney = curSettleMoney;
    }
    public BigDecimal getCurContractPayMoney() {
        return curContractPayMoney;
    }

    public void setCurContractPayMoney(BigDecimal curContractPayMoney) {
        this.curContractPayMoney = curContractPayMoney;
    }
    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }
    public String getIncomeCode() {
        return incomeCode;
    }

    public void setIncomeCode(String incomeCode) {
        this.incomeCode = incomeCode;
    }
    public BigDecimal getWaitDeductMny() {
        return waitDeductMny;
    }

    public void setWaitDeductMny(BigDecimal waitDeductMny) {
        this.waitDeductMny = waitDeductMny;
    }
    public Integer getSalaryFlag() {
        return salaryFlag;
    }

    public void setSalaryFlag(Integer salaryFlag) {
        this.salaryFlag = salaryFlag;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getApplyType() {
        return applyType;
    }

    @ReferDeserialTransfer
    public void setApplyType(Long applyType) {
        this.applyType = applyType;
    }

    public String getApplyTypeName() {
        return applyTypeName;
    }

    public void setApplyTypeName(String applyTypeName) {
        this.applyTypeName = applyTypeName;
    }
    public BigDecimal getSumContractSalary() {
        return sumContractSalary;
    }

    public void setSumContractSalary(BigDecimal sumContractSalary) {
        this.sumContractSalary = sumContractSalary;
    }
    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }
    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }
    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }
    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayWay() {
        return payWay;
    }

    @ReferDeserialTransfer
    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }

    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }
    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }
    public Integer getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }
    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }
    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }
    public Integer getContractTypeExtend() {
        return contractTypeExtend;
    }

    public void setContractTypeExtend(Integer contractTypeExtend) {
        this.contractTypeExtend = contractTypeExtend;
    }
    public Long getSubContractType() {
        return subContractType;
    }

    public void setSubContractType(Long subContractType) {
        this.subContractType = subContractType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getOthContractType() {
        return othContractType;
    }

    @ReferDeserialTransfer
    public void setOthContractType(Long othContractType) {
        this.othContractType = othContractType;
    }

    public String getOthContractTypeName() {
        return othContractTypeName;
    }

    public void setOthContractTypeName(String othContractTypeName) {
        this.othContractTypeName = othContractTypeName;
    }
    public Integer getReceiveInvoiceFlag() {
        return receiveInvoiceFlag;
    }

    public void setReceiveInvoiceFlag(Integer receiveInvoiceFlag) {
        this.receiveInvoiceFlag = receiveInvoiceFlag;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getTotalApplyLaborMny() {
        return totalApplyLaborMny;
    }

    public void setTotalApplyLaborMny(BigDecimal totalApplyLaborMny) {
        this.totalApplyLaborMny = totalApplyLaborMny;
    }
    public BigDecimal getShouldPayLaborMny() {
        return shouldPayLaborMny;
    }

    public void setShouldPayLaborMny(BigDecimal shouldPayLaborMny) {
        this.shouldPayLaborMny = shouldPayLaborMny;
    }
    public BigDecimal getSumPayLaborMny() {
        return sumPayLaborMny;
    }

    public void setSumPayLaborMny(BigDecimal sumPayLaborMny) {
        this.sumPayLaborMny = sumPayLaborMny;
    }
    public BigDecimal getPayLaborMny() {
        return payLaborMny;
    }

    public void setPayLaborMny(BigDecimal payLaborMny) {
        this.payLaborMny = payLaborMny;
    }
    
     public List<PayApplySalaryVO> getSalaryList() {
        return salaryList;
     }

     public void setSalaryList(List<PayApplySalaryVO> salaryList) {
        this.salaryList = salaryList;
     }
     public List<PayApplySummaryVO> getSummaryList() {
        return summaryList;
     }

     public void setSummaryList(List<PayApplySummaryVO> summaryList) {
        this.summaryList = summaryList;
     }
}
