package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labor.vo.PointTicketsDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 点工单
 * 
 * @author generator
 * 
 */
public class PointTicketsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long teamId; // 班组
    private String teamName; // 班组名称
    private Integer teamNum; // 班组人数
    private Long employeeId; // 打卡负责人
    private String employeeName; // 打卡负责人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date workDate; // 打卡日期
    private String billCode; // 单据编号
    private Integer workNum; // 打卡人数
    private Integer billState; // 单据状态
    
    private List<PointTicketsDetailVO> pointTicketsDetailList = new ArrayList<>(); // 点工单-人员信息
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "projectTeamRef")
    public Long getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Integer getTeamNum() {
        return teamNum;
    }

    public void setTeamNum(Integer teamNum) {
        this.teamNum = teamNum;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getWorkDate() {
        return workDate;
    }

    public void setWorkDate(Date workDate) {
        this.workDate = workDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getWorkNum() {
        return workNum;
    }

    public void setWorkNum(Integer workNum) {
        this.workNum = workNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<PointTicketsDetailVO> getPointTicketsDetailList() {
        return pointTicketsDetailList;
     }

     public void setPointTicketsDetailList(List<PointTicketsDetailVO> pointTicketsDetailList) {
        this.pointTicketsDetailList = pointTicketsDetailList;
     }
}
