package com.ejianc.business.labor.controller.api;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/attendance/")
public class AttendanceApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttendanceService attendanceService;

    @GetMapping({"/queryNumByProjAndQj"})
    CommonResponse<Integer> queryNumByProjAndQj(@RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate, @RequestParam("projectId") Long projectId) {
        LambdaQueryWrapper<AttendanceEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(AttendanceEntity::getProjectId, projectId);
        queryWrapper.ge(StringUtils.isNotEmpty(beginDate), AttendanceEntity::getPunchCardDate, beginDate);
        queryWrapper.le(StringUtils.isNotEmpty(endDate), AttendanceEntity::getPunchCardDate, endDate);
        return CommonResponse.success("查询人员id成功！", attendanceService.count(queryWrapper));
    }
}
