/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.SalaryDetailEntity;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salary")
public class SalaryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISalaryService salaryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SALARYSLIP_CODE";
    @Autowired
    private ISalarySlipService salarySlipService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SalaryEntity salaryEntity = (SalaryEntity)((Object)this.salaryService.selectById(billId));
        List<SalaryDetailEntity> salaryDetailList = salaryEntity.getSalaryDetailList();
        if (CollectionUtils.isNotEmpty(salaryDetailList)) {
            List salarySlipList = BeanMapper.mapList(salaryDetailList, SalarySlipEntity.class);
            for (SalarySlipEntity entity : salarySlipList) {
                entity.setSalaryDetailId(entity.getId());
                entity.setId(null);
                entity.setVersion(null);
                entity.setCreateUserCode(null);
                entity.setCreateTime(null);
                entity.setUpdateUserCode(null);
                entity.setUpdateTime(null);
                entity.setProjectId(salaryEntity.getProjectId());
                entity.setProjectName(salaryEntity.getProjectName());
                entity.setOrgId(salaryEntity.getOrgId());
                entity.setOrgName(salaryEntity.getOrgName());
                entity.setAckFlag(0);
                entity.setSalaryMonth(salaryEntity.getSalaryMonth());
                SalarySlipVO salarySlipVO = (SalarySlipVO)BeanMapper.map((Object)((Object)entity), SalarySlipVO.class);
                if (entity.getId() != null && entity.getId() != 0L) continue;
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salarySlipVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            this.salarySlipService.saveBatch(salarySlipList, salarySlipList.size());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = stringCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)stringCommonResponse.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"salary_id", (Object)billId);
        List list = this.salarySlipService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.salarySlipService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success();
    }
}

