/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserInfoValidateUtil {
    public static final int IDENTITYCODE_OLD = 15;
    public static final int IDENTITYCODE_NEW = 18;
    public static int[] Wi = new int[17];

    public static boolean verifyPhone(String phone) {
        String regex = "^[1]([3-9])[0-9]{9}$";
        boolean isMatch = false;
        if (StringUtils.isNotBlank((CharSequence)phone) && phone.length() == 11) {
            isMatch = Pattern.matches(regex, phone);
        }
        return isMatch;
    }

    public static boolean isIdentityCode(String code) {
        if (code == null || "".equals(code.trim())) {
            return false;
        }
        String birthDay = "";
        if ((code = code.trim()).length() != 15 && code.length() != 18) {
            return false;
        }
        Pattern pt = Pattern.compile("\\d{15,17}([\\dxX]{1})?");
        Matcher mt = pt.matcher(code);
        return mt.find();
    }

    private static String getCheckFlag(String code) {
        int[] varArray = new int[code.length()];
        String lastNum = "";
        int numSum = 0;
        UserInfoValidateUtil.setWiBuffer();
        for (int i = 0; i < code.length(); ++i) {
            varArray[i] = new Integer("" + code.charAt(i));
            varArray[i] = varArray[i] * Wi[i];
            numSum += varArray[i];
        }
        int checkDigit = 12 - numSum % 11;
        switch (checkDigit) {
            case 10: {
                lastNum = "X";
                break;
            }
            case 11: {
                lastNum = "0";
                break;
            }
            case 12: {
                lastNum = "1";
                break;
            }
            default: {
                lastNum = String.valueOf(checkDigit);
            }
        }
        return lastNum;
    }

    private static void setWiBuffer() {
        for (int i = 0; i < Wi.length; ++i) {
            int k = (int)Math.pow(2.0, Wi.length - i);
            UserInfoValidateUtil.Wi[i] = k % 11;
        }
    }

    public static boolean empty(String o) {
        return null == o || o.length() <= 0 || o.trim().equals("");
    }

    public static String update2eighteen(String code) {
        if (code == null || "".equals(code.trim())) {
            return "";
        }
        if ((code = code.trim()).length() != 15 || !UserInfoValidateUtil.isIdentityCode(code)) {
            return "";
        }
        code = code.substring(0, 6) + "19" + code.substring(6);
        code = code + UserInfoValidateUtil.getCheckFlag(code);
        return code;
    }

    public static String resume2fifteen(String code) {
        if (code == null || "".equals(code.trim())) {
            return "";
        }
        if ((code = code.trim()).length() != 18) {
            return "";
        }
        StringBuffer codebuffer = new StringBuffer(code);
        codebuffer.delete(6, 8);
        codebuffer.deleteCharAt(codebuffer.length() - 1);
        return codebuffer.toString();
    }

    public static void main(String[] args) {
        String[] codeArray = new String[]{"62272219850510261x", "53010119810602007x", "53010119810602001x"};
        for (int i = 0; i < codeArray.length; ++i) {
            if (UserInfoValidateUtil.isIdentityCode(codeArray[i])) {
                System.out.println(codeArray[i] + "\uff1a\u4e3a\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\uff01");
                continue;
            }
            System.out.println(codeArray[i] + "\uff1a\u4e3a\u9519\u8bef\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\uff01");
        }
        System.out.println("\u8f6c\u6362\u540e\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a\uff1a" + UserInfoValidateUtil.update2eighteen("330521820721052"));
        System.out.println("\u8f6c\u6362\u540e\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a\uff1a" + UserInfoValidateUtil.resume2fifteen("62272219850510261x"));
    }
}

