package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.mapper.AttendanceMapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;


/**
 * 考勤记录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Service("attendanceService")
public class AttendanceServiceImpl extends BaseServiceImpl<AttendanceMapper, AttendanceEntity> implements IAttendanceService {


    @Override
    public BigDecimal totalAttendanceDays(Date enterDate, Date exitDate, Long workerId, Long projectId) {
        QueryWrapper<AttendanceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL( SUM( IFNULL( actual_days, 1 )), 0 ) as actualDays");
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("worker_id", workerId);
        queryWrapper.between("punch_card_date", enterDate, exitDate);
        Map<String, Object> map = this.getMap(queryWrapper);
        return ComputeUtil.toBigDecimal(map.get("actualDays"));
    }


    /**
     * 按个人统计分页查询
     *
     * @param p       分页
     * @param wrapper 条件构造器
     *
     * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
     */
    @Override
    public IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate) {
        return baseMapper.queryPageByPerson(p, wrapper, startDate, endDate);
    }

    @Override
    public Integer queryAttendanceOrgIds(String orgIds){
        return baseMapper.queryAttendanceOrgIds(orgIds);
    }

}
