/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.EnterPlanDetailEntity;
import com.ejianc.business.labor.mapper.EnterPlanDetailMapper;
import com.ejianc.business.labor.service.IEnterPlanDetailService;
import com.ejianc.business.labor.utils.UserInfoValidateUtil;
import com.ejianc.business.labor.vo.EnterPlanDetailVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="enterPlanDetailService")
public class EnterPlanDetailServiceImpl
extends BaseServiceImpl<EnterPlanDetailMapper, EnterPlanDetailEntity>
implements IEnterPlanDetailService {
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<EnterPlanDetailVO> successList = new ArrayList<EnterPlanDetailVO>();
        ArrayList<EnterPlanDetailVO> errorList = new ArrayList<EnterPlanDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 11) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            CommonResponse derResp = this.defdocApi.getDefDocByDefCode("labor_worker_type");
            HashMap<String, Integer> idCardMap = new HashMap<String, Integer>();
            HashMap<String, Integer> phoneMap = new HashMap<String, Integer>();
            for (int i = 1; i < result.size(); ++i) {
                int rowNum = i + 2;
                List datas = (List)result.get(i);
                StringBuilder errMsg = new StringBuilder();
                EnterPlanDetailVO vo = new EnterPlanDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setName((String)datas.get(0));
                if (StringUtils.isBlank((String)((String)datas.get(0)))) {
                    errMsg.append("`\u540d\u5b57\u4e3a\u5fc5\u586b\u9879`");
                }
                if (((String)datas.get(1)).length() == 0) {
                    errMsg.append("`\u8eab\u4efd\u8bc1\u4e3a\u5fc5\u586b\u9879`");
                }
                if (datas.get(1) != null && StringUtils.isNotBlank((String)((String)datas.get(1)))) {
                    String idCard = ((String)datas.get(1)).trim();
                    if (!idCardMap.containsKey(idCard)) {
                        if (!idCard.matches(IdCardRegex)) {
                            errMsg.append("`\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef`");
                        }
                        idCardMap.put(idCard, rowNum);
                        vo.setIdCard(idCard);
                    } else {
                        errMsg.append("`\u7b2c" + idCardMap.get(idCard) + "\u3001" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d`");
                    }
                }
                if (datas.get(2) != null) {
                    if ("\u7537".equals(datas.get(2))) {
                        vo.setSex(Integer.valueOf(1));
                    } else if ("\u5973".equals(datas.get(2))) {
                        vo.setSex(Integer.valueOf(2));
                    }
                } else {
                    errMsg.append("`\u6027\u522b\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(3)))) {
                    try {
                        vo.setBirthDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble((String)datas.get(3))));
                    }
                    catch (Exception e) {
                        vo.setErrorMessage("\u51fa\u751f\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                } else {
                    errMsg.append("`\u51fa\u751f\u65e5\u671f\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(4)))) {
                    vo.setUserAge(Integer.valueOf((String)datas.get(4)));
                } else {
                    errMsg.append("`\u5e74\u9f84\u5e74\u9f84\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(5)))) {
                    vo.setNation((String)datas.get(5));
                } else {
                    errMsg.append("`\u6c11\u65cf\u4e3a\u5fc5\u586b\u9879`");
                }
                String phone = (String)datas.get(6);
                vo.setPhone(StringUtils.isNotBlank((String)phone) ? phone : null);
                if (StringUtils.isNotBlank((String)phone)) {
                    if (UserInfoValidateUtil.verifyPhone(phone = phone.trim())) {
                        if (!phoneMap.containsKey(phone)) {
                            phoneMap.put(phone, rowNum);
                        } else {
                            errMsg.append("`\u7b2c" + phoneMap.get(phone) + "\u3001" + rowNum + "\u884c\u624b\u673a\u53f7\u91cd\u590d`");
                        }
                    } else {
                        errMsg.append("`\u624b\u673a\u53f7\u4e0d\u6b63\u786e`");
                    }
                } else {
                    errMsg.append("`\u624b\u673a\u53f7\u4e3a\u5fc5\u586b\u9879`");
                }
                vo.setWorkTypeName((String)datas.get(7));
                if (StringUtils.isNotBlank((String)((String)datas.get(7)))) {
                    List<String> workTypes = Arrays.asList(((String)datas.get(7)).trim().split(","));
                    if (derResp.isSuccess()) {
                        List defList = (List)derResp.getData();
                        List defNames = defList.stream().map(x -> x.getName()).distinct().collect(Collectors.toList());
                        if (defNames.containsAll(workTypes)) {
                            List workerTypeList = defList.stream().filter(x -> workTypes.contains(x.getName())).collect(Collectors.toList());
                            vo.setWorkType(workerTypeList.stream().map(x -> String.valueOf(x.getId())).collect(Collectors.joining(",")));
                            vo.setWorkTypeName(workerTypeList.stream().map(x -> x.getName()).collect(Collectors.joining(",")));
                        } else {
                            errMsg.append("`\u5de5\u79cd\u8ddf\u6863\u6848\u4e0d\u5339\u914d`");
                        }
                    } else {
                        errMsg.append("`\u5de5\u79cd\u67e5\u8be2\u5931\u8d25`");
                    }
                } else {
                    errMsg.append("`\u5de5\u79cd\u4e3a\u5fc5\u586b\u9879`");
                }
                if (((String)datas.get(8)).length() == 0) {
                    errMsg.append("`\u5f00\u6237\u884c\u4e3a\u5fc5\u586b\u9879`");
                }
                vo.setBankName((String)datas.get(8));
                if (StringUtils.isNotBlank((String)((String)datas.get(9))) && !((String)datas.get(9)).matches(regex)) {
                    errMsg.append("`\u94f6\u884c\u5361\u53f7\u586b\u5199\u9519\u8bef`");
                }
                if (((String)datas.get(9)).length() == 0) {
                    errMsg.append("`\u94f6\u884c\u8d26\u53f7\u4e3a\u5fc5\u586b\u9879`");
                }
                vo.setBankAccount((String)datas.get(9));
                if (StringUtils.isNotBlank((String)((String)datas.get(10)))) {
                    try {
                        vo.setWage(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u586b\u9879`");
                }
                vo.setErrorMessage(errMsg.toString());
                if (StringUtils.isBlank((String)vo.getErrorMessage())) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

