/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.mapper.SalaryMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.business.labor.vo.importSalaryDetailVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="salaryService")
public class SalaryServiceImpl
extends BaseServiceImpl<SalaryMapper, SalaryEntity>
implements ISalaryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectTeamService projectTeamService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long projectId = Long.parseLong(request.getParameter("sourceId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<importSalaryDetailVO> successList = new ArrayList<importSalaryDetailVO>();
        ArrayList<importSalaryDetailVO> errorList = new ArrayList<importSalaryDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            HashMap<String, Integer> idCardMap = new HashMap<String, Integer>();
            for (int i = 1; i < result.size(); ++i) {
                int rowNum = i + 2;
                List datas = (List)result.get(i);
                StringBuilder errMsg = new StringBuilder();
                importSalaryDetailVO salaryDetailVO = new importSalaryDetailVO();
                salaryDetailVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((String)((String)datas.get(0)))) {
                    errMsg.append("`\u540d\u5b57\u4e3a\u5fc5\u586b\u9879`");
                }
                salaryDetailVO.setWorkerName((String)datas.get(0));
                if (((String)datas.get(1)).length() == 0) {
                    errMsg.append("`\u8eab\u4efd\u8bc1\u4e3a\u5fc5\u586b\u9879`");
                }
                if (datas.get(1) != null && StringUtils.isNotBlank((String)((String)datas.get(1)))) {
                    String idCard = ((String)datas.get(1)).trim();
                    if (!idCardMap.containsKey(idCard)) {
                        if (!idCard.matches(IdCardRegex)) {
                            errMsg.append("`\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef`");
                        }
                        idCardMap.put(idCard, rowNum);
                        salaryDetailVO.setIdCard(idCard);
                    } else {
                        errMsg.append("`\u7b2c" + idCardMap.get(idCard) + "\u3001" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d`");
                    }
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(2)))) {
                    try {
                        salaryDetailVO.setPrice(new BigDecimal((String)datas.get(2)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(3)))) {
                    try {
                        salaryDetailVO.setActualCheckNum(new BigDecimal((String)datas.get(3)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u8003\u52e4/\u5de5\u7a0b\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u8003\u52e4/\u5de5\u7a0b\u91cf\u4e3a\u5fc5\u586b\u9879`");
                }
                if (salaryDetailVO.getActualCheckNum() != null && salaryDetailVO.getPrice() != null) {
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)salaryDetailVO.getActualCheckNum(), (BigDecimal)salaryDetailVO.getPrice());
                    salaryDetailVO.setMny(mny);
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(5)))) {
                    try {
                        salaryDetailVO.setDeductMny(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5956\u7f5a\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                salaryDetailVO.setDeductReason((String)datas.get(6));
                BigDecimal shouldSalaryMny = ComputeUtil.safeAdd((BigDecimal)salaryDetailVO.getMny(), (BigDecimal)salaryDetailVO.getDeductMny());
                salaryDetailVO.setShouldSalaryMny(shouldSalaryMny);
                salaryDetailVO.setMemo((String)datas.get(8));
                QueryWrapper objectQueryWrapper = new QueryWrapper();
                objectQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                objectQueryWrapper.eq((Object)"id_card", (Object)salaryDetailVO.getIdCard());
                objectQueryWrapper.eq((Object)"project_id", (Object)projectId);
                objectQueryWrapper.eq((Object)"wage", (Object)salaryDetailVO.getPrice());
                objectQueryWrapper.orderByDesc((Object)"enter_date");
                List list = this.workRecordService.list((Wrapper)objectQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    WorkRecordEntity entity = (WorkRecordEntity)((Object)list.get(0));
                    salaryDetailVO.setContractId(entity.getSubContractId());
                    salaryDetailVO.setContractName(entity.getSubContractName());
                    salaryDetailVO.setSupplierId(entity.getSupplierId());
                    salaryDetailVO.setSupplierName(entity.getSupplierName());
                    salaryDetailVO.setWorkerId(entity.getWorkerId());
                    salaryDetailVO.setWorkerName(entity.getName());
                    salaryDetailVO.setPhone(entity.getPhone());
                    salaryDetailVO.setSex(null != entity.getSex() ? String.valueOf(entity.getSex()) : null);
                    salaryDetailVO.setTeamId(entity.getTeamId());
                    salaryDetailVO.setTeamName(entity.getTeamName());
                    salaryDetailVO.setWorkType(entity.getWorkType());
                    salaryDetailVO.setWorkTypeName(entity.getWorkTypeName());
                    salaryDetailVO.setBankName(entity.getBankName());
                    salaryDetailVO.setBankCard(entity.getBankAccount());
                    salaryDetailVO.setWagesType(null != entity.getWagesType() ? String.valueOf(entity.getWagesType()) : null);
                    this.logger.info("\u8eab\u4efd\u8bc1\u53f7\u5339\u914d\u7684\u4fe1\u606f" + JSONObject.toJSONString((Object)((Object)entity)));
                    if (entity.getEnterDate() != null && entity.getExitDate() != null) {
                        String enterDate = EJCDateUtil.format(entity.getEnterDate(), "yyyy-MM-dd");
                        String exitDate = EJCDateUtil.format(entity.getExitDate(), "yyyy-MM-dd");
                        List<String> dayBetween = EJCDateUtil.getDayBetween(enterDate, exitDate);
                        salaryDetailVO.setSysCheckNum(Integer.valueOf(dayBetween.size()));
                    }
                    salaryDetailVO.setSource("1");
                } else {
                    salaryDetailVO.setSource("2");
                    errMsg.append("`\u672a\u5339\u914d\u5230\u5bf9\u5e94\u8eab\u4efd\u8bc1+\u5de5\u4ef7\u6570\u636e\uff01`");
                }
                salaryDetailVO.setErrorMessage(errMsg.toString());
                if (StringUtils.isBlank((String)salaryDetailVO.getErrorMessage())) {
                    successList.add(salaryDetailVO);
                    continue;
                }
                errorList.add(salaryDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public Integer haveSalaryFlag(Long workerId, String exitDate) {
        return ((SalaryMapper)this.baseMapper).haveSalaryFlag(workerId, exitDate);
    }

    @Override
    public List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month, Long projectId, String createTime) {
        return ((SalaryMapper)this.baseMapper).queryWorkerAttendanceList(workerId, month, projectId, createTime);
    }

    @Override
    public List<SalaryVO> querySalaryPage(QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page) {
        return ((SalaryMapper)this.baseMapper).querySalaryPage(wrapper, salaryMonth, page);
    }
}

