package com.ejianc.business.labor.controller.api;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/projectTeam/")
public class ProjectTeamApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private ISalarySlipService salarySlipService;
    @Autowired
    private IProjectTeamService projectTeamService;

    @GetMapping({"/queryTeamWorkerIdByPhone"})
    CommonResponse<List<Long>> queryTeamWorkerIdByPhone( String phone,Long projectId){
        List<Long> workIds=new ArrayList<>();
        List<Long> teamIds = new ArrayList<>();
        QueryWrapper<ProjectTeamEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("phone",phone);
        objectQueryWrapper.eq("project_id",projectId);
        List<ProjectTeamEntity> projectTeamList = projectTeamService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(projectTeamList)){
             teamIds = projectTeamList.stream().filter(s -> s.getId() != null).map(ProjectTeamEntity::getId).
                    collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(teamIds)){
                if (CollectionUtils.isNotEmpty(teamIds)){
                    List<WorkRecordVO> workRecordVOs = salarySlipService.queryWorkByTeamId(projectId,teamIds);
                    workIds = workRecordVOs.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordVO::getWorkerId).
                            collect(Collectors.toList());
                }
            }
         }
          return CommonResponse.success("查询人员id成功！", workIds);
    }
    /**
     * 修改工资条的申请金额
     * @param map
     * @return
     */
    @PostMapping({"/updateAlreadyApplyMny"})
    CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map){
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)){
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper<SalarySlipEntity> objectLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                objectLambdaUpdateWrapper.eq(SalarySlipEntity::getId,id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny,alreadyApplyMny);
                salarySlipService.update(objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success("修改已经申请金额成功！");
    }
    /**
     * 根据手机号和项目id查询人员Id
     * @param phone
     * @return
     */
    @GetMapping({"/queryWorkerIdByPhone"})
    CommonResponse<List<Long>> queryWorkerIdByPhone(@RequestParam("phone") String phone){
        List<Long> workerIds = new ArrayList<>();
        QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("phone",phone);
        List<WorkRecordEntity> workRecordList = workRecordService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(workRecordList)){
            workerIds = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getWorkerId).distinct().
                    collect(Collectors.toList());
        }
        return CommonResponse.success("查询人员id成功！",workerIds);
    }

    /**
     * 初始化项目花名册
     * @param json
     * @return
     */
    @PostMapping({"/initData"})
    CommonResponse<String> initData(@RequestBody JSONObject json){
        String str = json.toJSONString();
        if(StringUtils.isEmpty(str)){
            logger.error("初始化项目花名册参数为空-{}", str);
            return CommonResponse.success("初始化项目花名册参数为空！");
        }
        ProjectPoolSetVO project = JSON.parseObject(str, new TypeReference<ProjectPoolSetVO>(){});
        //根据项目id查询
        Long projectId = project.getId();
        if(null == projectId){
            logger.error("projectId为空-{}", str);
            return CommonResponse.success("projectId为空！");
        }
        LambdaQueryWrapper<ProjectTeamEntity> ew = new LambdaQueryWrapper<>();
        ew.eq(ProjectTeamEntity::getProjectId, projectId);
        ew.eq(ProjectTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<ProjectTeamEntity> list = projectTeamService.list(ew);
        if(CollectionUtils.isNotEmpty(list)){
            logger.error("已存在项目花名册-{}", str);
            return CommonResponse.success("已存在项目花名册！");
        }
        ProjectTeamEntity entity = new ProjectTeamEntity();
        Long id = IdWorker.getId();
        entity.setId(id);
        entity.setInnerCode(id.toString());
        entity.setIsLeaf(true);
        entity.setName(project.getName());
        entity.setProjectId(project.getId());
        entity.setProjectName(project.getName());
        entity.setOrgId(project.getProjectDepartmentId());
        entity.setParentOrgId(project.getOrgId());
        entity.setParentOrgName(project.getOrgName());
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), new OrgTeamVO());
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            logger.error("网络异常， 编码生成失败， 请稍后再试");
            return CommonResponse.success("编码生成失败！");
        }
        entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        projectTeamService.save(entity);
        return CommonResponse.success("初始化项目花名册成功！");
    }
}
