/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectTeam/"})
public class ProjectTeamApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private ISalarySlipService salarySlipService;
    @Autowired
    private IProjectTeamService projectTeamService;

    @GetMapping(value={"/queryTeamWorkerIdByPhone"})
    CommonResponse<List<Long>> queryTeamWorkerIdByPhone(String phone, Long projectId) {
        List<Object> workIds = new ArrayList();
        ArrayList<Long> teamIds = new ArrayList();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        objectQueryWrapper.eq((Object)"project_id", (Object)projectId);
        List projectTeamList = this.projectTeamService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)projectTeamList) && CollectionUtils.isNotEmpty(teamIds = projectTeamList.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(teamIds)) {
            List<WorkRecordVO> workRecordVOs = this.salarySlipService.queryWorkByTeamId(projectId, teamIds);
            workIds = workRecordVOs.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordVO::getWorkerId).collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458id\u6210\u529f\uff01", workIds);
    }

    @PostMapping(value={"/updateAlreadyApplyMny"})
    CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map) {
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper objectLambdaUpdateWrapper = new LambdaUpdateWrapper();
                objectLambdaUpdateWrapper.eq(BaseEntity::getId, (Object)id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny, (Object)alreadyApplyMny);
                this.salarySlipService.update((Wrapper)objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u5df2\u7ecf\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryWorkerIdByPhone"})
    CommonResponse<List<Long>> queryWorkerIdByPhone(@RequestParam(value="phone") String phone) {
        List<Object> workerIds = new ArrayList();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        List workRecordList = this.workRecordService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)workRecordList)) {
            workerIds = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getWorkerId).distinct().collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458id\u6210\u529f\uff01", workerIds);
    }

    @PostMapping(value={"/initData"})
    CommonResponse<String> initData(@RequestBody JSONObject json) {
        String str = json.toJSONString();
        if (StringUtils.isEmpty((CharSequence)str)) {
            this.logger.error("\u521d\u59cb\u5316\u9879\u76ee\u82b1\u540d\u518c\u53c2\u6570\u4e3a\u7a7a-{}", (Object)str);
            return CommonResponse.success((String)"\u521d\u59cb\u5316\u9879\u76ee\u82b1\u540d\u518c\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        ProjectPoolSetVO project = (ProjectPoolSetVO)JSON.parseObject((String)str, (TypeReference)new TypeReference<ProjectPoolSetVO>(){}, (Feature[])new Feature[0]);
        Long projectId = project.getId();
        if (null == projectId) {
            this.logger.error("projectId\u4e3a\u7a7a-{}", (Object)str);
            return CommonResponse.success((String)"projectId\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(ProjectTeamEntity::getProjectId, (Object)projectId);
        ew.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.projectTeamService.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.error("\u5df2\u5b58\u5728\u9879\u76ee\u82b1\u540d\u518c-{}", (Object)str);
            return CommonResponse.success((String)"\u5df2\u5b58\u5728\u9879\u76ee\u82b1\u540d\u518c\uff01");
        }
        ProjectTeamEntity entity = new ProjectTeamEntity();
        Long id = IdWorker.getId();
        entity.setId(id);
        entity.setInnerCode(id.toString());
        entity.setIsLeaf(true);
        entity.setName(project.getName());
        entity.setProjectId(project.getId());
        entity.setProjectName(project.getName());
        entity.setOrgId(project.getProjectDepartmentId());
        entity.setParentOrgId(project.getOrgId());
        entity.setParentOrgName(project.getOrgName());
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)new OrgTeamVO());
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            this.logger.error("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            return CommonResponse.success((String)"\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
        }
        entity.setCode((String)billCode.getData());
        this.projectTeamService.save((Object)entity);
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u9879\u76ee\u82b1\u540d\u518c\u6210\u529f\uff01");
    }
}

