/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.PayApplyEntity;
import com.ejianc.business.labor.bean.PayApplySalaryEntity;
import com.ejianc.business.labor.bean.PayApplySummaryEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.mapper.PayApplyMapper;
import com.ejianc.business.labor.service.IPayApplySalaryService;
import com.ejianc.business.labor.service.IPayApplyService;
import com.ejianc.business.labor.service.IPayApplySummaryService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.PayApplySalaryVO;
import com.ejianc.business.labor.vo.PayApplySummaryVO;
import com.ejianc.business.labor.vo.PayApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="payApplyService")
public class PayApplyServiceImpl
extends BaseServiceImpl<PayApplyMapper, PayApplyEntity>
implements IPayApplyService {
    private static final String BILL_CODE = "LABOR_PAY_APPLY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayApplySalaryService salaryService;
    @Autowired
    private IPayApplySummaryService summaryService;
    @Autowired
    private ISalarySlipService salarySlipService;

    @Override
    public PayApplyVO saveOrUpdate(PayApplyVO saveOrUpdateVO) {
        PayApplyEntity entity = (PayApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        Long id = entity.getId();
        List<PayApplySalaryVO> payContractSalaryVOS = this.updateSalary(saveOrUpdateVO, id);
        List<PayApplySummaryVO> payContractSummaryVOS = this.updateSummary(saveOrUpdateVO, id);
        PayApplyVO vo = (PayApplyVO)BeanMapper.map((Object)((Object)entity), PayApplyVO.class);
        return vo;
    }

    @Override
    public String delete(List<PayApplyVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
        removeWrapper.in(PayApplySalaryEntity::getPayapplyId, ids);
        List salaryList = this.salaryService.list((Wrapper)removeWrapper);
        super.removeByIds(ids, true);
        this.writeBackAlreadyApplyMny(BeanMapper.mapList((Iterable)salaryList, PayApplySalaryVO.class));
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    private List<PayApplySalaryVO> updateSalary(PayApplyVO vo, Long id) {
        List delSalList;
        List voList = vo.getSalaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        ArrayList<PayApplySalaryVO> updSalarys = new ArrayList<PayApplySalaryVO>();
        if (voList != null && !voList.isEmpty()) {
            for (PayApplySalaryVO salaryVO : voList) {
                salaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayApplySalaryEntity.class);
            this.salaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayApplySalaryVO.class);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
            updSalarys.addAll(voList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(delSalList = this.salaryService.list((Wrapper)wrapper)))) {
            List delSalVOList = BeanMapper.mapList((Iterable)delSalList, PayApplySalaryVO.class);
            updSalarys.addAll(delSalVOList);
        }
        this.salaryService.remove((Wrapper)wrapper);
        this.writeBackAlreadyApplyMny(updSalarys);
        return voList;
    }

    private List<PayApplySummaryVO> updateSummary(PayApplyVO vo, Long id) {
        List voList = vo.getSummaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (voList != null && !voList.isEmpty()) {
            for (PayApplySummaryVO summaryVO : voList) {
                summaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayApplySummaryEntity.class);
            this.summaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayApplySummaryVO.class);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.summaryService.remove((Wrapper)wrapper, false);
        return voList;
    }

    public Boolean writeBackAlreadyApplyMny(List<PayApplySalaryVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            List salaryIds = list.stream().distinct().map(PayApplySalaryVO::getSalaryId).collect(Collectors.toList());
            LambdaQueryWrapper ew = new LambdaQueryWrapper();
            ew.in(PayApplySalaryEntity::getSalaryId, salaryIds);
            List salaryList = this.salaryService.list((Wrapper)ew);
            Map<Long, BigDecimal> map = salaryList.stream().collect(Collectors.groupingBy(PayApplySalaryEntity::getSalaryId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getApplyMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd))));
            for (Long salaryId : salaryIds) {
                if (map.containsKey(salaryId)) continue;
                map.put(salaryId, BigDecimal.ZERO);
            }
            this.updateAlreadyApplyMny(map);
        }
        return true;
    }

    public CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map) {
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper objectLambdaUpdateWrapper = new LambdaUpdateWrapper();
                objectLambdaUpdateWrapper.eq(BaseEntity::getId, (Object)id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny, (Object)alreadyApplyMny);
                this.salarySlipService.update((Wrapper)objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u5df2\u7ecf\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }
}

