package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 分包记录付款阶段实体
 */
@TableName("ejc_laborsub_contract_record_payment")
public class RecordPaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 付款阶段名称
     */
    @TableField("payment_name")
    private String paymentName;

    /**
     * 付款阶段比例(%)
     */
    @TableField("payment_scale")
    private BigDecimal paymentScale;

    /**
     * 备注
     */
    @TableField("mark")
    private String mark;

    /**
     * 所属合同Id
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    /**
     * 记录表ID
     */
    @TableField("record_id")
    private Long recordId;


    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPaymentScale() {
        return paymentScale;
    }

    public void setPaymentScale(BigDecimal paymentScale) {
        this.paymentScale = paymentScale;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
}
