package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.laborsub.utils.TreeNodeBUtil;
import com.ejianc.business.laborsub.vo.ContractDetailVO;
import com.ejianc.business.laborsub.vo.ContractOtherCostVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.ContractOtherCostEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.DraftTypeEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractOtherCostService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService{

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IContractOtherCostService otherCostService;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "LABORSUB_CONTRACT";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Value("${common.env.base-host}")
    private String BaseHost;

    /**
     * 新增或者修改合同
     * @param saveorUpdateVO
     * @return
     */
    @Override
    public ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority) {
        ContractEntity entity = BeanMapper.map(saveorUpdateVO, ContractEntity.class);
        if(entity.getId() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {

                entity.setSignatureStatus(String.valueOf(SignatureStatusEnum.未签章.getCode()));
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

                entity.setMainContractCreateDate(new Date());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设置初始金额
        entity.setBaseMoney(entity.getContractAmt());
        entity.setBaseMoneyWithTax(entity.getContractAmtWithTax());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractAmt());
        entity.setBeforeChangeMnyWithTax(entity.getContractAmtWithTax());

        if (entity.getContractFileId() != null){
            if (entity.getId() != null){
                ContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())){
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())){
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
        }


        //设置项目部id和项目部上级组织id
        if (null != entity.getOrgId()){
            OrgVO orgVO = iOrgApi.getOneById(entity.getOrgId()).getData();
            if (null != orgVO.getParentId()){
                entity.setParentOrgId(orgVO.getParentId());
                entity.setParentOrgName(orgVO.getpFName());
            }
        }

        //保存前清空主键和父主键，重新生成
        List<ContractDetailEntity> beforeDetails = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String, Long> idMap = new HashMap<>();
            for(ContractDetailEntity cdEntity : beforeDetails){
                if (cdEntity.getId() == null){
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : beforeDetails) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
        super.saveOrUpdate(entity, false);

//        List<ContractDetailEntity> supplementDetailEntities = entity.getDetailList();
//        if(CollectionUtils.isNotEmpty(supplementDetailEntities)) {
//
//            for (ContractDetailEntity cdEntity : supplementDetailEntities) {
//                idMap.put(cdEntity.getTid(), cdEntity.getId());
//            }
//
//            contractDetailService.saveOrUpdateBatch(entity.getDetailList(), entity.getDetailList().size(), false);
//        }

        return queryDetail(entity.getId());
    }

    //删除合同附件
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null){
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    /**
     * 计算合同列表需要字段
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
//        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_money_with_tax) as baseTaxMoney, sum(contract_amt_with_tax) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    /**
     * 查询合同详情
     * @param id
     * @return
     */
    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);
        contractVO.setContractType(1);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        //设置明细内容
        List<ContractDetailEntity> detailEntityListDb = detailService.queryList(queryParam, false);
//        List<ContractDetailEntity> detailEntityList = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
//            detailEntityListDb.forEach(entity -> {
//                if (null == entity.getChangeType()) {
//                    detailEntityList.add(entity);
//                }
//            });
//        }
        //代码简化，合成一行
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            for (ContractDetailEntity cdEntity : detailEntityListDb) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
            List<ContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityListDb, ContractDetailVO.class);
            contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }
        //设置其他花费内容
        List<ContractOtherCostEntity> otherCostEntityListDb = otherCostService.queryList(queryParam, false);
//        List<ContractOtherCostEntity> otherCostEntityList = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)){
//            otherCostEntityListDb.forEach(entity -> {
//                if (null == entity.getChangeType()){
//                    otherCostEntityList.add(entity);
//                }
//            });
//        }
        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)){
//            for (ContractOtherCostEntity ocEntity : otherCostEntityList) {
//                ocEntity.setRowState("edit");
//            }
            List<ContractOtherCostVO> resultMapList = BeanMapper.mapList(otherCostEntityListDb, ContractOtherCostVO.class);
            contractVO.setOtherCostList(resultMapList);
        }

        return contractVO;
    }


    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO recordVO = new ContractVO();

        BigDecimal contractAmtWithTax = contractEntity.getContractAmtWithTax() == null ? BigDecimal.ZERO : contractEntity.getContractAmtWithTax();

        recordVO.setId(id);
        recordVO.setContractAmtWithTax(contractAmtWithTax);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());

        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.orderByDesc(ContractEntity::getSignDate);

        List<ContractEntity> supplementEntities = super.list(lambda);


        recordVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        recordVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)){
            for (ContractEntity c : supplementEntities){
                if (c.getContractAmtWithTax() != null){
                    allSupplementAmt = c.getContractAmtWithTax().add(allSupplementAmt);
                }
            }
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        //设置补充金额比例
        recordVO.setSupplementAmtRate(BigDecimal.ZERO != allSupplementAmt && BigDecimal.ZERO != contractAmtWithTax ? (allSupplementAmt.divide(contractAmtWithTax, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().toString().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode() == contractEntity.getBillState() || BillStateEnum.COMMITED_STATE.getBillStateCode() == contractEntity.getBillState())){
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    /**
     * 新增或者修改补充协议
     * @param saveorUpdateVO
     * @return
     */
    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO) {
        ContractEntity entity = BeanMapper.map(saveorUpdateVO, ContractEntity.class);

        if(saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0 ){
            //新增补充协议
            if (saveorUpdateVO.getMainContractId() != null) {

                //补充协议只能存在一条未生效的
                LambdaQueryWrapper<ContractEntity> lambdaQuery = Wrappers.<ContractEntity>lambdaQuery();
                lambdaQuery.eq(ContractEntity::getMainContractId, saveorUpdateVO.getMainContractId());
                lambdaQuery.and(l -> l.ne(ContractEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode().toString()).or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode())));
                int num = service.count(lambdaQuery);
                if(num > 0){
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }

                List<ContractDetailEntity> detailList = entity.getDetailList();
                List<ContractOtherCostEntity> otherCostList = entity.getOtherCostList();
                List<ContractClauseEntity> clauseList = entity.getClauseList();

                //添加补充协议编码规则
                QueryParam parm = new QueryParam();
                parm.getParams().put("main_contract_id", new Parameter("eq", entity.getMainContractId()));
                List<ContractEntity> supplementList = service.queryList(parm, false);
                String supplementNum = "";
                if (supplementList.size() < 9) {
                    supplementNum += "0" + (supplementList.size() + 1);
                }else {
                    supplementNum += (supplementList.size() + 1);
                }

                //主合同
                ContractEntity mainContract = service.selectById(saveorUpdateVO.getMainContractId());
                if (mainContract != null) {
                    entity = BeanMapper.map(mainContract, ContractEntity.class);
                    entity.setId(null);
                    entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode().toString());
                    entity.setCreateTime(null);
                    entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                    entity.setBillCode(entity.getBillCode() + "2" + supplementNum);

                    //基本信息
                    entity.setContractName(saveorUpdateVO.getContractName());
                    entity.setSignDate(saveorUpdateVO.getSignDate());
                    entity.setOperatorId(saveorUpdateVO.getOperatorId());
                    entity.setOperatorName(saveorUpdateVO.getOperatorName());
                    entity.setPerformanceStatus(saveorUpdateVO.getPerformanceStatus());

                    entity.setDraftType(saveorUpdateVO.getDraftType());
                    //设置文件路径
                    entity.setContractFilePath(saveorUpdateVO.getContractFilePath());
                    entity.setContractFileId(saveorUpdateVO.getContractFileId());

                    entity.setContractTemplateId(saveorUpdateVO.getContractTemplateId());
                    entity.setContractTemplateName(saveorUpdateVO.getContractTemplateName());
                    entity.setContractFileVersionId(saveorUpdateVO.getContractFileVersionId());
                    entity.setContractFileVersion(saveorUpdateVO.getContractFileVersion());
                    entity.setSupplementDescribe(saveorUpdateVO.getSupplementDescribe());

                    //补充金额明细
                    entity.setContractAmt(saveorUpdateVO.getContractAmt());
                    entity.setContractAmtWithTax(saveorUpdateVO.getContractAmtWithTax() == null ? new BigDecimal("0") : saveorUpdateVO.getContractAmtWithTax());
                    entity.setContractTaxAmt(saveorUpdateVO.getContractTaxAmt());
                    //分包明细
                    entity.setSubContractAmt(saveorUpdateVO.getSubContractAmt());
                    entity.setSubContractAmtWithTax(saveorUpdateVO.getSubContractAmtWithTax());
                    entity.setSubContractTaxAmt(saveorUpdateVO.getSubContractTaxAmt());
                    //其他费用
                    entity.setOtherAmt(saveorUpdateVO.getOtherAmt());
                    entity.setOtherAmtWithTax(saveorUpdateVO.getOtherAmtWithTax());
                    entity.setOtherTaxAmt(saveorUpdateVO.getOtherTaxAmt());
                    //子表
                    entity.setDetailList(detailList);
                    entity.setOtherCostList(otherCostList);
                    entity.setClauseList(clauseList);

                    //初始化变更字段
                    entity.setChangingMny(null);
                    entity.setChangeCode(null);
                    entity.setChangeVersion(null);
                    entity.setChangeId(null);
                    entity.setChangeStatus(1);

                    //补充协议状态
                    entity.setSupplementFlag(1);
                    entity.setMainContractId(saveorUpdateVO.getMainContractId());
                    entity.setMainContractCode(saveorUpdateVO.getMainContractCode());
                    entity.setMainContractName(saveorUpdateVO.getMainContractName());

                }else {
                    throw new BusinessException("未找到主合同，不能创建补充协议！");
                }
            }
        }


        //设置初始金额
        entity.setBaseMoney(entity.getContractAmt());
        entity.setBaseMoneyWithTax(entity.getContractAmtWithTax());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractAmt());
        entity.setBeforeChangeMnyWithTax(entity.getContractAmtWithTax());
        //设置关联的附件Ids
        entity.setAttachIds(saveorUpdateVO.getAttachIds());


        //保存前清空主键和父主键，重新生成
        List<ContractDetailEntity> beforeDetails = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String,Long> idMap=new HashMap<>();
            for(ContractDetailEntity cdEntity : beforeDetails){
                if (cdEntity.getId() == null){
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(),cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for(ContractDetailEntity cdEntity : beforeDetails){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
        service.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }


    /**
     * 查询补充协议代入的主合同信息
     * @param contractId
     * @return
     */
    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(1);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");

        return supplementVO;
    }


    /**
     * 判断当前合同是否能新增补充协议
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, 1);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ContractEntity> supplementList = super.list(lambda);
        if (supplementList.size() > 0){
            return false;
        }
        return true;
    }









}
