package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.laborsub.utils.TreeNodeBUtil;
import com.ejianc.business.laborsub.vo.ContractDetailVO;
import com.ejianc.business.laborsub.vo.ContractOtherCostVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.laborsub.vo.RecordVO;
import com.ejianc.business.sub.bean.ContractOtherCostEntity;
import com.ejianc.business.sub.bean.RecordDetailEntity;
import com.ejianc.business.sub.bean.RecordOtherCostEntity;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.service.IRecordDetailService;
import com.ejianc.business.sub.service.IRecordOtherCostService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.RecordMapper;
import com.ejianc.business.sub.bean.RecordEntity;
import com.ejianc.business.sub.service.IRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包记录实体
 * 
 * @author generator
 * 
 */
@Service("recordService")
public class RecordServiceImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements IRecordService{
    @Autowired
    private IRecordDetailService recordDetailService;

    @Autowired
    private IRecordOtherCostService recordOtherCostService;

    @Override
    public ContractVO queryDetail(Long id) {
        //        RecordEntity contractEntity = super.selectById(id);
        LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
        lambda.eq(RecordEntity::getChangeId, id);

        RecordEntity recordEntity = super.getOne(lambda);
//        RecordEntity recordEntity = super.selectById(contractEntity.getId());

        ContractVO contractVO =  BeanMapper.map(recordEntity, ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, recordEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<RecordDetailEntity> detailEntityListDb = recordDetailService.queryList(queryParam, false);
        List<RecordDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(RecordDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getSrcTableId().toString());
                cdEntity.setId(cdEntity.getSrcTableId());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<ContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }


        //设置其他花费内容
        List<RecordOtherCostEntity> otherCostEntityListDb = recordOtherCostService.queryList(queryParam, false);
        List<RecordOtherCostEntity> otherCostEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)){
            otherCostEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType()){
                    otherCostEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherCostEntityList)){
            for (RecordOtherCostEntity ocEntity : otherCostEntityList) {
                ocEntity.setRowState("edit");
            }
            List<ContractOtherCostVO> resultMapList = BeanMapper.mapList(otherCostEntityList, ContractOtherCostVO.class);
            contractVO.setOtherCostList(resultMapList);
        }

        return contractVO;
    }
}
