/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "LABORSUB_CONTRACT";
    @Autowired
    private IContractService service;
    private final String ENTITY_REF_CODE = "laborSubContract";
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = this.service.insertOrUpdate(saveorUpdateVO, authority);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse billTypeResp = this.billTypeApi.getByRefCode("laborSubContract");
        if (!billTypeResp.isSuccess()) {
            this.logger.error("\u6839\u636erefCode-{}\u67e5\u8be2\u5bf9\u5e94\u5143\u6570\u636e\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)"laborSubContract", (Object)billTypeResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)((BillTypeVO)billTypeResp.getData()).getBillCode());
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(10000);
        CommonResponse<JSONObject> commonResponse = this.pageList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(c -> {
                if (null == c.getPerformanceStatus() || "1".equals(c.getPerformanceStatus())) {
                    c.setPerformanceStatus("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(c.getPerformanceStatus())) {
                    c.setPerformanceStatus("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(c.getPerformanceStatus())) {
                    c.setPerformanceStatus("\u5df2\u5c01\u8d26");
                } else if ("4".equals(c.getPerformanceStatus())) {
                    c.setPerformanceStatus("\u5df2\u89e3\u9664");
                }
                if (null == c.getSignatureStatus() || "1".equals(c.getSignatureStatus())) {
                    c.setSignatureStatus("\u672a\u7b7e\u7ae0");
                } else if ("2".equals(c.getSignatureStatus())) {
                    c.setSignatureStatus("\u5f85\u4e59\u65b9\u7b7e\u7ae0");
                } else if ("3".equals(c.getSignatureStatus())) {
                    c.setSignatureStatus("\u5f85\u7532\u65b9\u7b7e\u7ae0");
                } else if ("4".equals(c.getSignatureStatus())) {
                    c.setSignatureStatus("\u5df2\u7b7e\u7ae0");
                }
                if (null == c.getBillState() || 0 == c.getBillState()) {
                    c.setBillStateName("\u81ea\u7531\u6001");
                } else if (1 == c.getBillState()) {
                    c.setBillStateName("\u5df2\u63d0\u4ea4");
                } else if (2 == c.getBillState()) {
                    c.setBillStateName("\u5ba1\u6279\u4e2d");
                } else if (3 == c.getBillState()) {
                    c.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                } else if (4 == c.getBillState()) {
                    c.setBillStateName("\u9a73\u56de");
                } else if (5 == c.getBillState()) {
                    c.setBillStateName("\u63d0\u4ea4\u540e\u6709\u4eba\u5ba1\u6279\u4e2d");
                }
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("laborsubContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        Long orgId = InvocationInfoProxy.getOrgId();
        List orgVOList = (List)this.iOrgApi.findChildrenByParentId(orgId).getData();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (OrgVO vo : orgVOList) {
            orgIdList.add(vo.getId());
        }
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO saveorUpdateVO) {
        ContractVO vo = this.service.saveOrUpdateSupplement(saveorUpdateVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        if (contractEntity != null) {
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().toString());
            contractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractEntity);
        }
        return CommonResponse.success();
    }
}

