package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.law.vo.FrozenFundZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资金冻结单
 * 
 * @author generator
 * 
 */
public class FrozenFundVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 异常解冻备注
    private BigDecimal frozenPrice; // 冻结总金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date frozenDate; // 冻结日期
    private String frozenCode; // 冻结编号
    private Long caseId; // 案件编号
    private String caseName; // 案件编号名称
    private Long frozenType; // 冻结类型
    private String frozenTypeName; // 冻结类型名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private Long departmentId; // 项目部
    private String departmentName; // 项目部名称
    private BigDecimal unfreezableAmount; //可解冻金额

    public BigDecimal getUnfreezableAmount() {
        return unfreezableAmount;
    }

    public void setUnfreezableAmount(BigDecimal unfreezableAmount) {
        this.unfreezableAmount = unfreezableAmount;
    }
    private List<FrozenFundZiVO> frozenFundZiList = new ArrayList<>(); // 资金冻结单子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public BigDecimal getFrozenPrice() {
        return frozenPrice;
    }

    public void setFrozenPrice(BigDecimal frozenPrice) {
        this.frozenPrice = frozenPrice;
    }
    public Date getFrozenDate() {
        return frozenDate;
    }

    public void setFrozenDate(Date frozenDate) {
        this.frozenDate = frozenDate;
    }
    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

    @ReferSerialTransfer(referCode = "law-case-registe")
    public Long getCaseId() {
        return caseId;
    }
    @ReferDeserialTransfer
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFrozenType() {
        return frozenType;
    }
    @ReferDeserialTransfer
    public void setFrozenType(Long frozenType) {
        this.frozenType = frozenType;
    }
    public String getFrozenTypeName() {
        return frozenTypeName;
    }

    public void setFrozenTypeName(String frozenTypeName) {
        this.frozenTypeName = frozenTypeName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectIdName) {
        this.projectName = projectIdName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentname) {
        this.departmentName = departmentname;
    }
    
     public List<FrozenFundZiVO> getFrozenFundZiList() {
        return frozenFundZiList;
     }

     public void setFrozenFundZiList(List<FrozenFundZiVO> frozenFundZiList) {
        this.frozenFundZiList = frozenFundZiList;
     }
}
