package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金冻结单子表
 *
 * @author generator
 */
public class FrozenFundZiVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long zhuId; // 主表id
    private BigDecimal frozenPrice; // 冻结金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date frozenDate; // 冻结日期
    private Long frozenState; // 冻结阶段
    private String frozenStateName; // 冻结阶段名称
    private String frozenCode; // 冻结编号
    private Long lawsuitCode; // 诉讼案号
    private String lawsuitCodeName; // 诉讼案号名称
    private String remark; // 备注
    private String frozenReason; // 冻结事由
    private Long departmentId; // 项目部
    private String departmentName; // 项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private Long departmentCode; // 项目部编号
    private String departmentCodeName; // 项目部编号名称
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    @Override
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(Long departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getDepartmentCodeName() {
        return departmentCodeName;
    }

    public void setDepartmentCodeName(String departmentCodeName) {
        this.departmentCodeName = departmentCodeName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }







    public String getFrozenReason() {
        return frozenReason;
    }

    public void setForzenReason(String forzenReason) {
        this.frozenReason = forzenReason;
    }

    public Long getLawsuitCode() {
        return lawsuitCode;
    }

    public void setLawsuitCode(Long lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }

    public String getLawsuitCodeName() {
        return lawsuitCodeName;
    }

    public void setLawsuitCodeName(String lawsuitCodeName) {
        this.lawsuitCodeName = lawsuitCodeName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getZhuId() {
        return zhuId;
    }

    public void setZhuId(Long zhuId) {
        this.zhuId = zhuId;
    }

    public BigDecimal getFrozenPrice() {
        return frozenPrice;
    }

    public void setFrozenPrice(BigDecimal frozenPrice) {
        this.frozenPrice = frozenPrice;
    }

    public Date getFrozenDate() {
        return frozenDate;
    }

    public void setFrozenDate(Date frozenDate) {
        this.frozenDate = frozenDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFrozenState() {
        return frozenState;
    }

    @ReferDeserialTransfer
    public void setFrozenState(Long frozenState) {
        this.frozenState = frozenState;
    }

    public String getFrozenStateName() {
        return frozenStateName;
    }

    public void setFrozenStateName(String frozenStateName) {
        this.frozenStateName = frozenStateName;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

}
