package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.law.vo.CasePaymentZiVO;

/**
 * 案件付款情况登记表
 * 
 * @author generator
 * 
 */
public class CasePaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long caseId; // 案件id
    private String caseCode; // 案件编号
    private String caseName; // 案件名称
    private Long paymentState; // 付款状态
    private String payStateName; // 付款状态名称
    private Long departmentId; // 项目部
    private String departmentName; // 项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private Long paymentType; // 付款类型
    private String lawsuitCode; // 诉讼编号
    private String payableCompany; // 应付单位
    private BigDecimal totalAmountPayable; // 应付总金额
    private BigDecimal totalAmountUnpaid; // 未付总金额
    private Long caseReport; // 案情通报
    private String caseReportName; // 案情通报名称
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String paymentTypeName; // 付款类型名称
    
    private List<CasePaymentZiVO> casePaymentZiList = new ArrayList<>(); // 案件付款情况登记子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    @ReferSerialTransfer(referCode = "law-case-registe")
    public Long getCaseId() {
        return caseId;
    }


    @ReferDeserialTransfer
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }


    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPaymentState() {
        return paymentState;
    }
    @ReferDeserialTransfer
    public void setPaymentState(Long paymentState) {
        this.paymentState = paymentState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPaymentType() {
        return paymentType;
    }
    @ReferDeserialTransfer
    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }
    public String getLawsuitCode() {
        return lawsuitCode;
    }

    public void setLawsuitCode(String lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }
    public String getPayableCompany() {
        return payableCompany;
    }

    public void setPayableCompany(String payableCompany) {
        this.payableCompany = payableCompany;
    }
    public BigDecimal getTotalAmountPayable() {
        return totalAmountPayable;
    }

    public void setTotalAmountPayable(BigDecimal totalAmountPayable) {
        this.totalAmountPayable = totalAmountPayable;
    }
    public BigDecimal getTotalAmountUnpaid() {
        return totalAmountUnpaid;
    }

    public void setTotalAmountUnpaid(BigDecimal totalAmountUnpaid) {
        this.totalAmountUnpaid = totalAmountUnpaid;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }
    public Long getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(Long caseReport) {
        this.caseReport = caseReport;
    }

    public String getCaseReportName() {
        return caseReportName;
    }

    public void setCaseReportName(String caseReportName) {
        this.caseReportName = caseReportName;
    }
     public List<CasePaymentZiVO> getCasePaymentZiList() {
        return casePaymentZiList;
     }

     public void setCasePaymentZiList(List<CasePaymentZiVO> casePaymentZiList) {
        this.casePaymentZiList = casePaymentZiList;
     }
}
