package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.FrozenFundZiEntity;
/**
 * 资金冻结单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_frozen_fund")
public class FrozenFundEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 异常解冻备注
    @TableField(value="frozen_stage_id")
    private String frozenStageId; // 冻结阶段
    @TableField(value="frozen_stage_name")
    private String frozenStageName; // 冻结阶段名称
    @TableField(value="frozen_price")
    private BigDecimal frozenPrice; // 冻结总金额
    @TableField(value="frozen_date")
    private Date frozenDate; // 冻结日期
    @TableField(value="frozen_code")
    private String frozenCode; // 冻结编号
    @TableField(value="unfreeze_price")
    private BigDecimal unfreezePrice; // 解冻金额
    @TableField(value="unfreeze_date")
    private Date unfreezeDate; // 解冻日期
    @TableField(value="unfreeze_code")
    private String unfreezeCode; // 解冻编号
    @TableField(value="hear_count")
    private Integer hearCount; // 审理阶段（0未审理，1一审，2二审，3再审）
    @TableField(value="case_id")
    private Long caseId; // 案件编号
    @TableField(value="case_name")
    private String caseName; // 案件编号名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="frozenFundZiService", pidName = "zhuId")
    private List<FrozenFundZiEntity> frozenFundZiList = new ArrayList<>(); // 资金冻结单子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getFrozenStageId() {
        return frozenStageId;
    }

    public void setFrozenStageId(String frozenStageId) {
        this.frozenStageId = frozenStageId;
    }
    public String getFrozenStageName() {
        return frozenStageName;
    }

    public void setFrozenStageName(String frozenStageName) {
        this.frozenStageName = frozenStageName;
    }
    public BigDecimal getFrozenPrice() {
        return frozenPrice;
    }

    public void setFrozenPrice(BigDecimal frozenPrice) {
        this.frozenPrice = frozenPrice;
    }
    public Date getFrozenDate() {
        return frozenDate;
    }

    public void setFrozenDate(Date frozenDate) {
        this.frozenDate = frozenDate;
    }
    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }
    public BigDecimal getUnfreezePrice() {
        return unfreezePrice;
    }

    public void setUnfreezePrice(BigDecimal unfreezePrice) {
        this.unfreezePrice = unfreezePrice;
    }
    public Date getUnfreezeDate() {
        return unfreezeDate;
    }

    public void setUnfreezeDate(Date unfreezeDate) {
        this.unfreezeDate = unfreezeDate;
    }
    public String getUnfreezeCode() {
        return unfreezeCode;
    }

    public void setUnfreezeCode(String unfreezeCode) {
        this.unfreezeCode = unfreezeCode;
    }
    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }
    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    

    public List<FrozenFundZiEntity> getFrozenFundZiList() {
        return frozenFundZiList;
    }

    public void setFrozenFundZiList(List<FrozenFundZiEntity> frozenFundZiList) {
        this.frozenFundZiList = frozenFundZiList;
    }
}
