package com.ejianc.business.law.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.law.desktop.vo.DepartmentRankVO;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.law.bean.InfoRegisterEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 案件审理信息登记表
 *
 * @author generator
 */
@Mapper
public interface InfoRegisterMapper extends BaseCrudMapper<InfoRegisterEntity> {


    List<Map<String, String>> getInfoRank();

    /**
     * 应诉涉案项目部排名
     *
     * @param wrapper
     * @return
     */
    List<DepartmentRankVO> getDepartmentRank(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper, @Param("year") Integer year);

    /**
     * 应诉涉案工程
     *
     * @param wrapper
     * @return
     */

    List<DepartmentRankVO> getProjectType(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper);

    /**
     * 起诉涉案项目部排名
     *
     * @param wrapper
     * @return
     */
    List<DepartmentRankVO> getProDepartmentRank(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper, @Param("year") Integer year);

    /**
     * 起诉涉案工程
     *
     * @param wrapper
     * @return
     */
    List<DepartmentRankVO> getProProjectType(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper);

    /**
     * 申请执行项目部排名
     *
     * @param wrapper
     * @return
     */
    List<DepartmentRankVO> getProExDepartmentRank(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper, @Param("year") Integer year);

    /**
     * 被执行项目部排名
     *
     * @param wrapper
     * @return
     */
    List<DepartmentRankVO> getExDepartmentRank(@Param(Constants.WRAPPER) QueryWrapper<DepartmentRankVO> wrapper, @Param("year") Integer year);

}
