package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.InnerCaseZiEntity;

/**
 * 内部仲裁登记
 *
 * @author generator
 */
@TableName("ejc_law_inner_case")
public class InnerCaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value = "operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "remark")
    private String remark; // 备注
    @TableField(value = "case_code")
    private String caseCode; // 案件编码
    @TableField(value = "important_flag")
    private String importantFlag; // 重点项目标识
    @TableField(value = "apply_person")
    private Long applyPerson; // 申请人
    @TableField(value = "apply_person_name")
    private String applyPersonName; // 申请人名称
    @TableField(value = "project_id")
    private Long projectId; // 工程
    @TableField(value = "project_name")
    private String projectName; // 工程名称
    @TableField(value = "execute")
    private Long execute; // 被执行人
    @TableField(value = "execute_name")
    private String executeName; // 被执行人名称
    @TableField(value = "dispute_type")
    private String disputeType; // 纠纷类型
    @TableField(value = "dispute_type_name")
    private String disputeTypeName; // 纠纷类型名称
    @TableField(value = "inner_mny")
    private BigDecimal innerMny; // 仲裁金额
    @TableField(value = "service_date")
    private Date serviceDate; // 开庭日期
    @TableField(value = "case_state")
    private String caseState; // 案件状态
    @TableField(value = "pay_state")
    private String payState; // 支付状态
    @TableField(value = "case_result")
    private String caseResult; // 案件结果
    @TableField(value = "apply_date")
    private Date applyDate; // 申请日期

    @TableField(exist = false)
    @SubEntity(serviceName = "innerCaseZiService",pidName = "zhuId")
    private List<InnerCaseZiEntity> innerCaseZiList = new ArrayList<>(); // 内部仲裁登记子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }

    public String getImportantFlag() {
        return importantFlag;
    }

    public void setImportantFlag(String importantFlag) {
        this.importantFlag = importantFlag;
    }

    public Long getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(Long applyPerson) {
        this.applyPerson = applyPerson;
    }

    public String getApplyPersonName() {
        return applyPersonName;
    }

    public void setApplyPersonName(String applyPersonName) {
        this.applyPersonName = applyPersonName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getExecute() {
        return execute;
    }

    public void setExecute(Long execute) {
        this.execute = execute;
    }

    public String getExecuteName() {
        return executeName;
    }

    public void setExecuteName(String executeName) {
        this.executeName = executeName;
    }

    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }

    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }

    public BigDecimal getInnerMny() {
        return innerMny;
    }

    public void setInnerMny(BigDecimal innerMny) {
        this.innerMny = innerMny;
    }

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public String getCaseState() {
        return caseState;
    }

    public void setCaseState(String caseState) {
        this.caseState = caseState;
    }

    public String getPayState() {
        return payState;
    }

    public void setPayState(String payState) {
        this.payState = payState;
    }

    public String getCaseResult() {
        return caseResult;
    }

    public void setCaseResult(String caseResult) {
        this.caseResult = caseResult;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public List<InnerCaseZiEntity> getInnerCaseZiList() {
        return innerCaseZiList;
    }

    public void setInnerCaseZiList(List<InnerCaseZiEntity> innerCaseZiList) {
        this.innerCaseZiList = innerCaseZiList;
    }
}
