package com.ejianc.business.law.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.law.bean.LedgerEntity;
import com.ejianc.business.law.bean.ProsecutionCaseRegisterEntity;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.business.law.service.IProsecutionCaseRegisterService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("prosecutionCaseRegister")
public class ProsecutionCaseRegisterBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IProsecutionCaseRegisterService service;
    @Autowired
    private ILedgerService ledgerService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        ProsecutionCaseRegisterEntity entity = service.getById(billId);
        LedgerEntity ledgerEntity = ledgerService.getOne(Wrappers.<LedgerEntity>lambdaQuery().eq(LedgerEntity::getCaseId, entity.getId()));
        LedgerEntity map = BeanMapper.map(entity, LedgerEntity.class);
        //案件台账关联更新
        if (ledgerEntity != null) {
            //案件类型1为应诉，2为起诉
            map.setCaseType(2);
            ledgerService.saveOrUpdate(map);
        } else {
            map.setId(null);
            map.setCaseType(2);
            ledgerService.saveOrUpdate(map);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
