package com.ejianc.business.base.bases.api;

import com.ejianc.business.base.bases.hystrix.BaseHystrix;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name= "ejc-lz-web", url="${common.env.feign-client-url}", path="ejc-lz-web", fallback = BaseHystrix.class)
public interface BaseApi {
    @PostMapping("/api/base/baseApi/getshippersinfo")
    CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value = "carCode") String carCode,@RequestParam(value = "orgId") Long orgId);
}
