package com.ejianc.business.base.bases.api;

import com.ejianc.business.base.bases.hystrix.BaseHystrix;
import com.ejianc.business.base.bases.vo.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-lz-web", url="${common.env.feign-client-url}", path="ejc-lz-web", fallback = BaseHystrix.class)
public interface BaseApi {
    @PostMapping("/api/base/baseApi/getshippersinfo")
    CommonResponse<ShippersInfoApiVO> getShippersInfo(@RequestParam(value = "carCode") String carCode,@RequestParam(value = "orgId") Long orgId);
    @PostMapping("/api/base/baseApi/updatestatus")
    CommonResponse updatestatus(@RequestParam(value = "vehicleId") Long vehicleId,@RequestParam(value = "status") Integer status);
    @GetMapping(value = "/api/base/baseApi/querymaterialdetail")
    CommonResponse<MaterialVO> querymaterialdetail(Long id);
    @GetMapping(value = "/api/base/baseApi/queryproductdetail")
    CommonResponse<ProductVO> queryproductdetail(Long id);
    @PostMapping(value = "/api/base/baseApi/querysettlement")
    CommonResponse<SettlementPerioddetailVO> querysettlement(@RequestParam(value = "month") String month,@RequestParam(value = "orgId") String orgId);
    @PostMapping(value = "/api/base/baseApi/queryunit")
    List<UnitVO> queryUnit(@RequestParam(value = "orgId")String orgId);
    //采购根据收货时间查找所在月份
    @PostMapping(value = "/api/base/baseApi/settlement")
    CommonResponse<String> settlement(@RequestParam(value = "receiptTime") String receiptTime,@RequestParam(value = "orgId") String orgId);
}
