package com.ejianc.business.market.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 开工报告
 * 
 * @author generator
 * 
 */
public class StartWorkReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private String billCode; // 单据编码
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    /**
     * 项目经理id
     */
    private Long projectManager;
    /**
     * 项目经理名称
     */
    private String projectManagerName;
    private String employeePhone; // 经办人电话
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门
    private Long parentOrgId; // 项目部上级组织id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startWorkDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimateEndDate; // 预计完工日期
    private String memo; // 备注
    private String orgCode; // 所属项目部编号

    // 2025-04-24 新增字段
    private Long projectDirector; // 项目总监id
    private String projectDirectorName; // 项目总监名称
    private Integer report; //是否办理开工报告（o=否 1=是）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartWorkDate; // 实际开工日期
    private Integer term; // 合同工期

    // 2025-05-26 新增字段
    private String contractType; // 合同签订类型
    private String constructionPermit; // 施工许可证
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDateByReport; // 竣工日期(按开工报告)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDateByActualStart; // 竣工日期(按实际开工)

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractSigningTime; // 合同签订时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String awardNoticeTime; // 中标通知书时间


    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getStartWorkDate() {
        return startWorkDate;
    }

    public void setStartWorkDate(Date startWorkDate) {
        this.startWorkDate = startWorkDate;
    }
    public Date getEstimateEndDate() {
        return estimateEndDate;
    }

    public void setEstimateEndDate(Date estimateEndDate) {
        this.estimateEndDate = estimateEndDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectDirector() {
        return projectDirector;
    }

    @ReferDeserialTransfer
    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }

    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }

    public Integer getReport() {
        return report;
    }

    public void setReport(Integer report) {
        this.report = report;
    }

    public Date getActualStartWorkDate() {
        return actualStartWorkDate;
    }

    public void setActualStartWorkDate(Date actualStartWorkDate) {
        this.actualStartWorkDate = actualStartWorkDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getConstructionPermit() {
        return constructionPermit;
    }

    public void setConstructionPermit(String constructionPermit) {
        this.constructionPermit = constructionPermit;
    }

    public Date getCompletionDateByReport() {
        return completionDateByReport;
    }

    public void setCompletionDateByReport(Date completionDateByReport) {
        this.completionDateByReport = completionDateByReport;
    }

    public Date getCompletionDateByActualStart() {
        return completionDateByActualStart;
    }

    public void setCompletionDateByActualStart(Date completionDateByActualStart) {
        this.completionDateByActualStart = completionDateByActualStart;
    }

    public Date getContractSigningTime() {
        return contractSigningTime;
    }

    public void setContractSigningTime(Date contractSigningTime) {
        this.contractSigningTime = contractSigningTime;
    }

    public String getAwardNoticeTime() {
        return awardNoticeTime;
    }

    public void setAwardNoticeTime(String awardNoticeTime) {
        this.awardNoticeTime = awardNoticeTime;
    }
}
