package com.ejianc.business.market.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


/**
 * 停工报告
 * 
 * @author generator
 * 
 */
@ApiModel("停工报告")
public class StopWorkReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("所属项目编码")
    private String projectCode;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("所属项目部编号")
    private String orgCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人电话")
    private String employeePhone;
    @ApiModelProperty("经办部门id")
    private Long departmentId;
    @ApiModelProperty("经办部门")
    private String departmentName;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("停工开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopWorkCreateDate;
    @ApiModelProperty("停工结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopWorkEndDate;
    @ApiModelProperty("停工时常")
    private Integer stopWorkEften;
    @ApiModelProperty("停工事由")
    private String memo;

    @ApiModelProperty("项目经理")
    private Long projectManager;

    @ApiModelProperty("项目经理名称")
    private String projectManagerName;


    private String beforeProjectStatus;

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }


    public String getBeforeProjectStatus() {
        return beforeProjectStatus;
    }

    public void setBeforeProjectStatus(String beforeProjectStatus) {
        this.beforeProjectStatus = beforeProjectStatus;
    }

    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 所属项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public String getEmployeePhone() {
        return employeePhone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    /**
     * 经办部门id
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 项目部上级组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 停工开始日期
     */
    public Date getStopWorkCreateDate() {
        return stopWorkCreateDate;
    }

    /**
     * 停工开始日期
     */
    public void setStopWorkCreateDate(Date stopWorkCreateDate) {
        this.stopWorkCreateDate = stopWorkCreateDate;
    }
    /**
     * 停工结束日期
     */
    public Date getStopWorkEndDate() {
        return stopWorkEndDate;
    }

    /**
     * 停工结束日期
     */
    public void setStopWorkEndDate(Date stopWorkEndDate) {
        this.stopWorkEndDate = stopWorkEndDate;
    }
    /**
     * 停工时常
     */
    public Integer getStopWorkEften() {
        return stopWorkEften;
    }

    /**
     * 停工时常
     */
    public void setStopWorkEften(Integer stopWorkEften) {
        this.stopWorkEften = stopWorkEften;
    }
    /**
     * 停工事由
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 停工事由
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

}
