package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 工程登记
 */
public class ProjectRegisterVO extends BaseVO {
    private static final long serialVersionUID = 6397319563174429996L;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 商机Id
     */
    private Long busOpprId;

    /**
     * 项目编号
     */
    private String code;
    /**
     * 项目名称
     */
    private String name;

    /**
     * 所属组织
     */
    private Long orgId;

    /**
     * 所属项目部Id
     */
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    private String status;

    /**
     * 项目状态：0-启用，1-停用
     */
    private String validStatus;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String type;

    /**
     * 承包模式
     *
     */
    private Long contractualModel;

    /**
     * 发包单位
     */
    private Long pubUnit;

    /**
     * 承包单位
     */
    private Long contractorUnit;

    /**
     * 项目地区
     */
    private String area;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 投资主体
     */
    private Long investor;

    /**
     * 资金来源
     */
    private String fundsSource;
    /**
     * 总造价(万元)
     */
    private BigDecimal costTotal;
    /**
     * 招标形式
     */
    private Long biddingForm;
    /**
     * 计划开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;
    /**
     * 计划竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;
    /**
     * 建筑面积(㎡)
     */
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    private Long structureType;
    /**
     * 工程用途
     */
    private Long engineeringPurpose;
    /**
     * 工程概况
     */
    private String projectOverview;

    /**
     * 项目成员
     */
    private List<Map<String, Object>> membersList;

    /**
     * 冗余所属组织名称
     */
    private String orgName;
    /**
     * 冗余承包单位名称
     */
    private String contractorUnitName;
    /**
     * 冗余发包单位名称
     */
    private String pubUnitName;

    /**
     * 承包模式
     */
    private String contractualModelName;

    /**
     * 投资主体
     */
    private String investorName;

    /**
     * 招标形式
     */
    private String biddingFormName;

    /**
     * 结构类型
     */
    private String structureTypeName;
    /**
     * 工程用途
     */
    private String engineeringPurposeName;

    /**
     * 创建人名称
     */
    private String createUserName;

    private String createTimeStr;
    private String statusName;
    private String typeName;
    private String validStatusName;

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    private String sourceId;

    private String sourceOrgId;

    /**
     * 数据来源系统Id
     */
    private Long systemId;

    /**
     * 数据来源系统编码
     */
    private String systemCode;

    /**
     * 签订日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 项目经理
     */
    private Long projectManager;

    /**
     * 项目经理名称
     */
    private String projectManagerName;

    /**
     * 工程类型
     */
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    private String engineeringTypeName;

    /**
     * 省份
     */
    private String province;

    /**
     * 市区
     */
    private String city;

    /**
     * 区县
     */
    private String region;

    /**
     * 是否使用材料核销
     */
    private Boolean materialVerification;

    /**
     * 关注类型 0-普通项目 1-工程局重点关注 2-工程局重点监控 3-二级单位重点关注 4-二级单位重点监控
     */
    private String focusType;

    private Long areaId; // 区域id
    private String areaCode; // 区域编码
    private String areaName; // 区域名称

    private java.lang.Integer measurementCertificate; // 是否有计量证书(0. 否 1. 是）
    private java.lang.Long mainOrgId; // 开票主体
    private java.lang.String mainOrgName; // 开票主体名称
    private java.lang.Integer invoiceMainCategory; // 开票主体分类(0-以集团名义开票 1-以区域分公司名义开票)
    private java.lang.Integer taxWay; // 计税方式(0-一般计税 1-简易计税)
    private String excuteConstructState;// 是否执行建造合同 0-否，1-是
    private String industryIntegrationFlag;// 是否启用业财一体化 0-否，1-是
    private String deptId; // 财务核算部门
    private String deptName; // 财务核算部门名称
    private java.lang.String provinces; // 省市区
    private java.lang.Long dutyOrgId; // 责任单位id
    private java.lang.String dutyOrgName; // 责任单位名称
    private java.lang.String deputyUnit; // 代建单位
    private java.lang.String designUnit; // 设计单位
    private java.lang.String supervisorUnit; // 监理单位
    private java.lang.String auditUnit; // 审计单位
    private java.lang.String bidProjectName; // 中标告知单名称
    private java.lang.Long bidProjectId; // 中标告知单
    private java.lang.String bidBillCode; // 中标告知单编号
    private Long postId;
    private java.lang.String projectStatus;//工程状态 0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
    private String projectStatusName;
    

    private List<MainOrgRecordVO> mainOrgRecordVos = new ArrayList<>(); // 开票主体记录

    public String getDeptId() {
        return deptId;
    }
    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getFocusType() {
        return focusType;
    }

    public void setFocusType(String focusType) {
        this.focusType = focusType;
    }


    public Boolean getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Boolean materialVerification) {
        this.materialVerification = materialVerification;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSystemId() {
        return systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    @ReferDeserialTransfer
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public List<Map<String, Object>> getMembersList() {
        return membersList;
    }

    public void setMembersList(List<Map<String, Object>> membersList) {
        this.membersList = membersList;
    }

    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getBusOpprId() {
        return busOpprId;
    }

    public void setBusOpprId(Long busOpprId) {
        this.busOpprId = busOpprId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getCreateTimeStr() {
        return null != this.getCreateTime() ? sdf.format(this.getCreateTime()) : null;
    }

    public String getStatusName() {
        return StringUtils.isNotBlank(this.status) ? ("1".equals(this.status) ? "未开工" : "2".equals(this.status) ? "在建" : "完工") : null;
    }

    public String getTypeName() {
        return "1".equals(this.type) ? "自营" : "联营";
    }

    public String getValidStatusName() {
        return "0".equals(this.validStatus) ? "启用" : "停用";
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSourceOrgId() {
        return sourceOrgId;
    }

    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Integer getMeasurementCertificate() {
        return measurementCertificate;
    }

    public void setMeasurementCertificate(Integer measurementCertificate) {
        this.measurementCertificate = measurementCertificate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getMainOrgId() {
        return mainOrgId;
    }
    @ReferDeserialTransfer
    public void setMainOrgId(Long mainOrgId) {
        this.mainOrgId = mainOrgId;
    }
    public String getMainOrgName() {
        return mainOrgName;
    }

    public void setMainOrgName(String mainOrgName) {
        this.mainOrgName = mainOrgName;
    }

    public Integer getInvoiceMainCategory() {
        return invoiceMainCategory;
    }

    public void setInvoiceMainCategory(Integer invoiceMainCategory) {
        this.invoiceMainCategory = invoiceMainCategory;
    }

    public Integer getTaxWay() {
        return taxWay;
    }

    public void setTaxWay(Integer taxWay) {
        this.taxWay = taxWay;
    }

    public String getExcuteConstructState() {
        return excuteConstructState;
    }

    public void setExcuteConstructState(String excuteConstructState) {
        this.excuteConstructState = excuteConstructState;
    }

    public String getIndustryIntegrationFlag() {
        return industryIntegrationFlag;
    }

    public void setIndustryIntegrationFlag(String industryIntegrationFlag) {
        this.industryIntegrationFlag = industryIntegrationFlag;
    }

    public List<MainOrgRecordVO> getMainOrgRecordVos() {
        return mainOrgRecordVos;
    }

    public void setMainOrgRecordVos(List<MainOrgRecordVO> mainOrgRecordVos) {
        this.mainOrgRecordVos = mainOrgRecordVos;
    }

    public String getProvinces() {
        return provinces;
    }

    public void setProvinces(String provinces) {
        this.provinces = provinces;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDutyOrgId() {
        return dutyOrgId;
    }
    @ReferDeserialTransfer
    public void setDutyOrgId(Long dutyOrgId) {
        this.dutyOrgId = dutyOrgId;
    }

    public String getDutyOrgName() {
        return dutyOrgName;
    }

    public void setDutyOrgName(String dutyOrgName) {
        this.dutyOrgName = dutyOrgName;
    }

    public String getDeputyUnit() {
        return deputyUnit;
    }

    public void setDeputyUnit(String deputyUnit) {
        this.deputyUnit = deputyUnit;
    }

    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }

    public String getSupervisorUnit() {
        return supervisorUnit;
    }

    public void setSupervisorUnit(String supervisorUnit) {
        this.supervisorUnit = supervisorUnit;
    }

    public String getAuditUnit() {
        return auditUnit;
    }

    public void setAuditUnit(String auditUnit) {
        this.auditUnit = auditUnit;
    }

    public String getBidProjectName() {
        return bidProjectName;
    }

    public void setBidProjectName(String bidProjectName) {
        this.bidProjectName = bidProjectName;
    }
    @ReferSerialTransfer(referCode="market-project-bidding-bid")
    public Long getBidProjectId() {
        return bidProjectId;
    }
    @ReferDeserialTransfer
    public void setBidProjectId(Long bidProjectId) {
        this.bidProjectId = bidProjectId;
    }
    public String getBidBillCode() {
        return bidBillCode;
    }

    public void setBidBillCode(String bidBillCode) {
        this.bidBillCode = bidBillCode;
    }
	public java.lang.String getProjectStatus() {
		return projectStatus;
	}

	public void setProjectStatus(java.lang.String projectStatus) {
		this.projectStatus = projectStatus;
	}
	//工程状态 0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
	public String getProjectStatusName() {
		return StringUtils.isNotBlank(this.projectStatus)
				? ("0".equals(this.projectStatus) ? "未开工" : "1".equals(this.projectStatus) ? "在建" : "2".equals(this.projectStatus) ? "完工未验收": "3".equals(this.projectStatus) ? "完工验收": "4".equals(this.projectStatus) ? "已验收未结算": "已结算")
				: null;
	}


}
