package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 开工报审表
 * 
 * @author generator
 * 
 */
public class ZydxProjectApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位名称
    private Long pubUnit; // 发包单位
    private String pubUnitName; // 发包单位名称
    private Long contractorUnit; // 承包单位
    private String contractorUnitName; // 承包单位名字
    private Long projectManager; // 项目经理
    private String projectManagerName; // 项目经理名称
    private Long establishmentUserId; // 编制人id
    private String establishmentUserName; // 编制人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制时间
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="zydx-customer")
    public Long getPubUnit() {
        return pubUnit;
    }

    @ReferDeserialTransfer
    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    @ReferSerialTransfer(referCode="zy_supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectManager() {
        return projectManager;
    }

    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    
}
