package com.ejianc.business.market.api;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.ProjectSubVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 项目rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = ProjectHystrix.class)
public interface IProjectApi {

	/**
	 * 根据sourceId查询项目详情
	 *
	 * @param sourceId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectBySourceId")
	public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/8/21 根据项目部id查询项目信息
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
	 */
	@GetMapping(value = "/api/project/queryProjectByProjectDepartmentId")
	CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") String projectDepartmentId);

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "/api/project/queryProjectByIds")
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestBody List<Long> ids);

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "/api/project/queryProjectArray")
	public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids);


	/**
	 * 根据条件查询对应项目ID列表
	 *
	 * @param projectRange 1-全部项目，2-在建项目，3-完工项目，4-本年新签项目
	 * @return
	 */
	@GetMapping(value = "/api/project/getProjectIdsByProperties")
	CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value = "projectRange") int projectRange);

	/**
	 * 供方协同---用户获取有权限的项目，为空代表全部项目的权限
	 *
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectByUserId")
	CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(@RequestParam(value = "userId") Long userId);

	/***
	 * @Author mrsir_wxp
	 * @Date 2021/2/1 查询本下启用的项目，参数为需要查询的条数，默认十条
	 * @Description queryProjectList
	 * @Param [num]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@GetMapping(value = "/api/project/queryProjectList")
	CommonResponse<List<ProjectRegisterVO>> queryProjectList(@RequestParam(value = "num",defaultValue = "10") int num);
	/**
	 * @Author mrsir_wxp
	 * @Date 2021/5/18
	 * @Description queryProjectPage
	 * @Param [queryParam]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@PostMapping(value = "/api/project/queryProjectPage")
	CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(@RequestBody QueryParam queryParam);

	/**
	 * @Author zhangwx
	 * @Date 2021/06/07 根据组织主键查询本下所有项目
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [orgId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@GetMapping(value = "/api/project/queryChildrenProjectByOrgId")
	CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(@RequestParam(value = "orgId") Long orgId);

	/**
	 * 根据组织主键查询本下项目地址，过滤条件项目状态、关注类型
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjects")
	CommonResponse<List<Map>> queryProjects(@RequestParam(value = "orgId") Long orgId,
											@RequestParam(value = "statusList", required = false) List<String> statusList,
											@RequestParam(value = "focusTypeList", required = false) List<String> focusTypeList,
											@RequestParam(value = "engineeringTypeList", required = false) List<Long> engineeringTypeList,
											@RequestParam(value = "searchText", required = false) String searchText);

	@GetMapping("/api/project/queryProjectDetail")
	CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据项目查对应的局内分包项目
	 * @param projectIds
	 * @return
	 */
	@PostMapping(value = "/no_auth/api/project/queryProjectSub")
	CommonResponse<Map<Long,List<ProjectSubVO>>> queryProjectSub(@RequestBody List<Long> projectIds);
}
