/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.ProjectApplyEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.service.IProjectApplyService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectApply"})
public class ProjectApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IBusinessOpportunityService businessOpportunityService;
    private static final String BILL_CODE = "marketProjectApply";
    @Autowired
    private IProjectApplyService service;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectApplyVO> saveOrUpdate(@RequestBody ProjectApplyVO saveOrUpdateVO) {
        BusinessOpportunityEntity buOpr;
        ProjectApplyEntity entity = (ProjectApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectApplyEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isEmpty((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getMembersList())) {
            entity.getMembersList().forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getRowState())) {
                    i.setRowStateName(i.getRowState());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getProjectCode()) || StringUtils.isNotBlank((CharSequence)entity.getName())) {
            QueryWrapper query = Wrappers.query();
            query.and(item -> {
                ((QueryWrapper)item.eq(StringUtils.isNotBlank((CharSequence)entity.getName()), (Object)"name", (Object)entity.getName())).or();
                item.eq(StringUtils.isNotBlank((CharSequence)entity.getProjectCode()), (Object)"code", (Object)entity.getProjectCode());
                return item;
            });
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            int count = this.projectRegisterService.count((Wrapper)query);
            if (count > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u7f16\u53f7/\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (null != saveOrUpdateVO.getBusOpprId() && null != (buOpr = (BusinessOpportunityEntity)((Object)this.businessOpportunityService.selectById(saveOrUpdateVO.getBusOpprId())))) {
            buOpr.setApplyIsSet(true);
            this.businessOpportunityService.saveOrUpdate((Object)buOpr, false);
        }
        ProjectApplyVO vo = (ProjectApplyVO)BeanMapper.map((Object)((Object)entity), ProjectApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectApplyVO> queryDetail(Long id) {
        ProjectApplyEntity entity = (ProjectApplyEntity)((Object)this.service.selectById(id));
        ProjectApplyVO vo = (ProjectApplyVO)BeanMapper.map((Object)((Object)entity), ProjectApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectApplyVO vo : vos) {
                BusinessOpportunityEntity buOpr;
                ProjectApplyEntity projectApplyEntity = (ProjectApplyEntity)((Object)this.service.selectById(vo.getId()));
                if (null == projectApplyEntity.getBusOpprId() || null == (buOpr = (BusinessOpportunityEntity)((Object)this.businessOpportunityService.selectById(projectApplyEntity.getBusOpprId())))) continue;
                this.logger.info("\u9879\u76ee\u5220\u9664\uff0c\u8fd8\u539f\u5bf9\u5e94\u5546\u673a[id-{}]\u5f15\u7528\u72b6\u6001", (Object)buOpr.getId());
                buOpr.setApplyIsSet(false);
                this.businessOpportunityService.saveOrUpdate((Object)buOpr, false);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("pubUnitName");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("createUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("pubUnitName");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("createUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)list, ProjectApplyVO.class));
        ExcelExport.getInstance().export("project-apply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectApplyVO>> refProjectApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

