/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.service.IProjectBidPeopleService;
import com.ejianc.business.market.service.IProjectOuterPeopleService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectBidPeopleVO;
import com.ejianc.business.market.vo.ProjectOuterPeopleVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"projectRegister"})
public class ProjectResigerController {
    private final String TEMPLATE_KEY_PREFIX = "template_data_cache_market_project";
    private final String TEMPLATE_KEY_SEPRATOR = ":";
    private final int TIMEOUT = 1800;
    private final String PROJECT_BILL_TYPE_CODE = "BT200519000000002";
    private static final Random random = new Random();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IProjectBidPeopleService bidPeopleService;
    @Autowired
    private IProjectOuterPeopleService outerPeopleService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBusinessOpportunityService businessOpportunityService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ICustomerApi customerApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IBillTypeApi billTypeApi;

    @PostMapping(value={"saveProject"})
    public CommonResponse<ProjectRegisterVO> saveProject(@RequestBody ProjectRegisterVO projectRegisterVO) {
        return this.projectRegisterService.saveProject(projectRegisterVO);
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> queryPageList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("shortName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("projectManagerName");
        queryParam.getFuzzyFields().add("projectOwner");
        queryParam.getFuzzyFields().add("pubUnit");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("pubUnit");
        Map<Object, Object> countProjectNum = null;
        Page pageData = null;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        if (CollectionUtils.isEmpty((Collection)orgVOList)) {
            pageData = new Page();
            pageData.setRecords(new ArrayList());
            pageData.setTotal(0L);
            pageData.setSize((long)queryParam.getPageSize());
            pageData.setCurrent((long)queryParam.getPageIndex());
            pageData.setPages(0L);
            countProjectNum = new HashMap<String, Integer>();
            countProjectNum.put("buildingNum", 0);
            countProjectNum.put("finishNum", 0);
        } else {
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else {
                queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
            pageData = this.projectRegisterService.queryPage(queryParam, false);
            countProjectNum = this.projectRegisterService.countProjectNum(queryParam);
        }
        resp.put("records", (Object)pageData.getRecords());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("size", (Object)pageData.getSize());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("pages", (Object)pageData.getPages());
        resp.put("projectCount", countProjectNum);
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u767b\u8bb0\u9879\u76ee\u5217\u8868\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"detail"})
    public CommonResponse<ProjectRegisterVO> detail(@RequestParam Long id) {
        ProjectRegisterVO resp = (ProjectRegisterVO)BeanMapper.map((Object)((Object)this.projectRegisterService.queryById(id)), ProjectRegisterVO.class);
        CommonResponse membersResp = this.userApi.getEmployeeList(resp.getProjectDepartmentId());
        if (!membersResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u6210\u5458\u5931\u8d25\u3002");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)resp.getId()));
        List bidPeopleEntityList = this.bidPeopleService.queryList(queryParam, false);
        resp.setBidPeopleList(BeanMapper.mapList((Iterable)bidPeopleEntityList, ProjectBidPeopleVO.class));
        List outerPeopleList = this.outerPeopleService.queryList(queryParam, false);
        resp.setOuterPeopleList(BeanMapper.mapList((Iterable)outerPeopleList, ProjectOuterPeopleVO.class));
        resp.setMembersList((List)membersResp.getData());
        for (Map map : resp.getMembersList()) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", map.get("postId"));
            jsonObj.put("name", map.get("postName"));
            map.put("postId", jsonObj);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u767b\u8bb0\u8be6\u60c5\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"delById"})
    public CommonResponse<String> deleteById(@RequestBody List<Long> ids) {
        Long projectId = ids.get(0);
        this.logger.info("\u6267\u884c\u9879\u76ee\u5220\u9664\u64cd\u4f5c\uff0c\u5220\u9664\u9879\u76ee[id-{}]", (Object)projectId);
        String userType = InvocationInfoProxy.getUserType();
        if (!"1".equals(userType) && !"3".equals(userType)) {
            return CommonResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6267\u884c\u9879\u76ee\u5220\u9664\u64cd\u4f5c\u3002");
        }
        CommonResponse resp = this.billTypeApi.checkQuote("BT200519000000002", projectId);
        if (!resp.isSuccess()) {
            this.logger.info("\u9879\u76ee\u7acb\u9879\u3010Id-{}\u3011\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u539f\u56e0\uff1a{}", (Object)projectId, (Object)resp.getMsg());
            return CommonResponse.error((String)"\u6821\u9a8c\u9879\u76ee\u4e0b\u6e38\u5f15\u7528\u72b6\u51b5\u5931\u8d25\uff0c\u5220\u9664\u64cd\u4f5c\u4e2d\u6b62.");
        }
        String result = this.projectRegisterService.delProject(projectId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return CommonResponse.error((String)result);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"changeValidStatus"})
    public CommonResponse<String> changeValidStatus(@RequestBody ProjectRegisterVO projectRegisterVO) {
        this.projectRegisterService.changeValidStatus(projectRegisterVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping(value={"/projectListRefer"})
    public CommonResponse<IPage<ProjectRegisterVO>> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam;
        block17: {
            queryParam = new QueryParam();
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setSearchText(searchText);
            queryParam.getFuzzyFields().add("code");
            queryParam.getFuzzyFields().add("name");
            queryParam.getFuzzyFields().add("orgName");
            queryParam.getFuzzyFields().add("shortName");
            queryParam.getFuzzyFields().add("createUserName");
            queryParam.getParams().put("validStatus", new Parameter("eq", (Object)Character.valueOf('0')));
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("createTime", "desc");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            Long orgId = InvocationInfoProxy.getOrgId();
            Boolean tenantLeave = false;
            Boolean mobileLeave = false;
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (null != conditionMap.get("tenantLeave")) {
                    tenantLeave = true;
                }
                if (null != conditionMap.get("mobileLeave")) {
                    mobileLeave = true;
                }
                if (null != conditionMap.get("province")) {
                    queryParam.getParams().put("province", new Parameter("eq", conditionMap.get("province")));
                }
                if (null != conditionMap.get("city")) {
                    queryParam.getParams().put("city", new Parameter("eq", conditionMap.get("city")));
                }
                if (null != conditionMap.get("region")) {
                    queryParam.getParams().put("region", new Parameter("eq", conditionMap.get("region")));
                }
                if (null != conditionMap.get("projectId")) {
                    queryParam.getParams().put("id", new Parameter("ne", conditionMap.get("projectId")));
                }
            }
            if (mobileLeave.booleanValue()) {
                CommonResponse response = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
                if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    break block17;
                } else {
                    Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u9879\u76ee\u6743\u9650\uff01", (Object)pageData);
                }
            }
            if (!tenantLeave.booleanValue()) {
                CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
                if (!orgListResp.isSuccess()) {
                    Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
                }
                List orgList = (List)orgListResp.getData();
                if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                    orgList.forEach(orgVO -> {
                        if (5 == orgVO.getOrgType()) {
                            departmentIds.add(orgVO.getId());
                        } else {
                            commonOrgIds.add(orgVO.getId());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                        queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
                    } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                        queryParam.getParams().put("projectDepartmentId", new Parameter("eq", departmentIds.get(0)));
                    }
                }
            }
        }
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class));
        return CommonResponse.success((String)"\u9879\u76ee\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"checkProjectName"})
    public CommonResponse<String> checkProjectName(@RequestBody ProjectRegisterVO projectRegisterVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ProjectRegisterEntity::getName, (Object)projectRegisterVO.getName());
        queryWrapper.ne(null != projectRegisterVO.getId(), BaseEntity::getId, (Object)projectRegisterVO.getId());
        int count = this.projectRegisterService.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u9879\u76ee\u540d\u79f0\u5df2\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
        return CommonResponse.success((String)"\u9879\u76ee\u540d\u79f0\u672a\u88ab\u4f7f\u7528\uff0c\u53ef\u4ee5\u4f7f\u7528\u3002");
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("shortName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("projectManagerName");
        queryParam.getFuzzyFields().add("projectOwner");
        queryParam.getFuzzyFields().add("pubUnit");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("pubUnit");
        queryParam.setPageSize(-1);
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class));
        ExcelExport.getInstance().export("project-export.xlsx", beans, response);
    }

    @PostMapping(value={"/excelExportByTemplateName"})
    public void excelExportByTemplateName(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        Map params = queryParam.getParams();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("shortName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("projectManagerName");
        queryParam.getFuzzyFields().add("projectOwner");
        queryParam.getFuzzyFields().add("pubUnit");
        queryParam.getFuzzyFields().add("contractorUnit");
        queryParam.getFuzzyFields().add("pubUnit");
        queryParam.setPageSize(-1);
        String templateName = ((Parameter)params.get("templateName")).getValue().toString();
        params.remove("templateName");
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class));
        ExcelExport.getInstance().export(templateName, beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"project-import.xlsx", (String)"\u9879\u76ee\u5bfc\u5165\u6a21\u677f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/saveImportTemplate"})
    public CommonResponse<JSONObject> saveImportData(@RequestBody String templatekey) {
        try {
            String jsonData = (String)((Object)this.cacheManager.get(templatekey));
            if (StringUtils.isBlank((CharSequence)jsonData)) {
                CommonResponse commonResponse = CommonResponse.error((String)"\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u53ef\u5bfc\u5165\u7684\u6570\u636e\u5185\u5bb9\uff01");
                return commonResponse;
            }
            List proList = JSONObject.parseArray((String)jsonData, ProjectRegisterVO.class);
            if (CollectionUtils.isEmpty((Collection)proList)) {
                CommonResponse commonResponse = CommonResponse.error((String)"\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6570\u636e\uff01");
                return commonResponse;
            }
            this.projectRegisterService.saveImportProject(proList);
            CommonResponse commonResponse = CommonResponse.success((String)"\u6570\u636e\u5bfc\u5165\u4fdd\u5b58\u6210\u529f\uff01");
            return commonResponse;
        }
        finally {
            this.cacheManager.removeCache(templatekey);
        }
    }

    @PostMapping(value={"/excelImport"})
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse resp) {
        JSONObject respData = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ProjectRegisterVO> saveList = new ArrayList<ProjectRegisterVO>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            this.logger.info("\u63a5\u6536\u5230\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\uff1a[{}]", (Object)originalFileName);
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u884c\u6570(\u5305\u542b\u975e\u6570\u636e\u884c)\uff1a[{}]", (Object)result.size());
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\uff1a[{}]", (Object)JSONObject.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            List rowData = null;
            Object dbList = null;
            ArrayList<String> saveNameList = new ArrayList<String>();
            ArrayList<String> saveCodeList = new ArrayList<String>();
            ProjectRegisterVO proInfo = null;
            for (int i = 1; i < result.size() && i < 100; ++i) {
                proInfo = new ProjectRegisterVO();
                rowData = (List)result.get(i);
                JSONObject errInfo = this.rowDataCheck(i, rowData, saveNameList, saveCodeList, proInfo);
                this.logger.info("\u7b2c{}\u884c\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)(i + 1), null != errInfo ? errInfo.get((Object)"errMsg") : "\u6821\u9a8c\u901a\u8fc7\uff01");
                if (null != errInfo) {
                    proInfo = null;
                    errorList.add(errInfo);
                    continue;
                }
                saveList.add(proInfo);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                String key = this.getCacheKey();
                respData.put("templateKey", (Object)key);
                this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString(saveList)), 1800);
            }
        }
        respData.put("importableNum", (Object)saveList.size());
        respData.put("errorList", errorList);
        return CommonResponse.success((Object)respData);
    }

    private String getCacheKey() {
        return "template_data_cache_market_project:" + InvocationInfoProxy.getUserid() + ":" + System.currentTimeMillis();
    }

    private JSONObject generateErrorRow(int rowNum, List<String> rowData, String msg) {
        JSONObject error = new JSONObject();
        error.put("rowNum", (Object)rowNum);
        error.put("code", (Object)rowData.get(0));
        error.put("shortName", (Object)rowData.get(1));
        error.put("name", (Object)rowData.get(2));
        error.put("pubUnitName", (Object)rowData.get(3));
        error.put("orgName", (Object)rowData.get(4));
        error.put("status", (Object)rowData.get(5));
        error.put("errMsg", (Object)msg);
        return error;
    }

    @PostMapping(value={"codeUsedCheck"})
    public CommonResponse<String> codeUsedCheck(@RequestBody ProjectRegisterVO project) {
        boolean checkResult = this.projectRegisterService.codeUsedCheck(project);
        if (checkResult) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    private JSONObject rowDataCheck(int rowNum, List<String> rowData, List<String> curVlidProNameList, List<String> curVlidProCodeList, ProjectRegisterVO proInfo) {
        OrgVO orgVO;
        String name = rowData.get(2);
        String shortName = rowData.get(1);
        String code = rowData.get(0);
        String orgName = rowData.get(4);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isNotBlank((CharSequence)shortName)) {
            if (shortName.length() > 50) {
                return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u7b80\u79f0\u6700\u591a50\u5b57");
            }
            shortName = shortName.replaceAll(" ", "");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a");
        }
        if ((name = name.replaceAll(" ", "")).length() > 50) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u540d\u79f0\u6700\u591a50\u5b57");
        }
        if (StringUtils.isNotBlank((CharSequence)code) && (code = code.replaceAll(" ", "")).length() > 64) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u7f16\u7801\u6700\u591a64\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)orgName)) {
            return this.generateErrorRow(rowNum, rowData, "\u6240\u5c5e\u7ec4\u7ec7\u4e3a\u7a7a");
        }
        orgName = orgName.replaceAll(" ", "");
        if (StringUtils.isBlank((CharSequence)rowData.get(5))) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rowData.get(6))) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (curVlidProNameList.contains(name)) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u540d\u79f0\u91cd\u590d");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        List dbList = this.projectRegisterService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            return this.generateErrorRow(rowNum, rowData, "\u9879\u76ee\u540d\u79f0\u91cd\u590d");
        }
        boolean codeCheck = curVlidProCodeList.contains(code);
        if (!codeCheck && StringUtils.isNotBlank((CharSequence)code)) {
            proInfo.setTenantId(tenantId);
            proInfo.setCode(code);
            codeCheck = this.projectRegisterService.codeUsedCheck(proInfo);
        }
        if (codeCheck) {
            return this.generateErrorRow(rowNum, rowData, "\u7f16\u7801\u91cd\u590d");
        }
        if (StringUtils.isNotBlank((CharSequence)rowData.get(3))) {
            CustomerVO customer = (CustomerVO)this.getRespData(this.customerApi.findOneByName(rowData.get(3), InvocationInfoProxy.getTenantid()), true, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u67e5\u8be2\u53d1\u5305\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            if (null == customer) {
                return this.generateErrorRow(rowNum, rowData, "\u53d1\u5305\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            proInfo.setPubUnit(customer.getId());
            proInfo.setPubUnitName(customer.getName());
        }
        if (null == (orgVO = (OrgVO)this.getRespData(this.orgApi.findByNameAndTenantId(orgName, InvocationInfoProxy.getTenantid()), true, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25"))) {
            return this.generateErrorRow(rowNum, rowData, "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        if (orgVO.getOrgType() == 5) {
            return this.generateErrorRow(rowNum, rowData, "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u662f\u9879\u76ee\u90e8\u7ec4\u7ec7");
        }
        curVlidProNameList.add(name);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            curVlidProCodeList.add(code);
            proInfo.setCode(code);
        }
        proInfo.setOrgId(orgVO.getId());
        proInfo.setOrgName(orgVO.getName());
        proInfo.setName(name);
        proInfo.setShortName(shortName);
        proInfo.setType("\u81ea\u8425".equals(rowData.get(6)) ? "1" : "2");
        if (StringUtils.isNotBlank((CharSequence)rowData.get(5))) {
            proInfo.setStatus("\u672a\u5f00\u5de5".equals(rowData.get(5)) ? "1" : ("\u5728\u5efa".equals(rowData.get(5)) ? "2" : "3"));
        }
        return null;
    }

    @GetMapping(value={"/maIndexCount"})
    public JSONObject maIndexProjectsCount(HttpServletRequest req) {
        JSONObject resp = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)Character.valueOf('0')));
        Map<String, Integer> numMap = this.projectRegisterService.countProjectNum(queryParam);
        numMap.put("total", numMap.get("buildingNum") + numMap.get("finishNum"));
        queryParam.getComplexParams().clear();
        List<Long> projectIds = this.projectRegisterService.queryProIdsByProperties(queryParam, true);
        numMap.put("newNumCurYear", projectIds.size());
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"\u67e5\u8be2\u6210\u529f\uff01");
        resp.put("data", numMap);
        return resp;
    }

    @GetMapping(value={"getProjectByCurrentOrg"})
    public CommonResponse<ProjectRegisterVO> getProjectByCurrentOrg() {
        QueryParam param = new QueryParam();
        param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        List entities = this.projectRegisterService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            // empty if block
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u9879\u76ee");
    }

    @PostMapping(value={"changeStatus"})
    public CommonResponse<ProjectRegisterVO> changeStatus(@RequestBody ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterVO resp = this.projectRegisterService.changeStatus(projectRegisterVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"no_auth/initQYWXAndDDDefaultProject"})
    public CommonResponse<JSONObject> initQYWXAndDDDefaultProject(@RequestBody JSONObject body) {
        if (body == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (body.getLong("tenantId") == null) {
            return CommonResponse.error((String)"\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (body.getLong("enterpriseId") == null) {
            return CommonResponse.error((String)"\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (body.getLong("orgId") == null || StringUtils.isEmpty((CharSequence)body.getString("orgName"))) {
            return CommonResponse.error((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)body.getLong("tenantId")));
        param.getParams().put("orgId", new Parameter("eq", (Object)body.getLong("orgId")));
        List projectRegisterEntities = this.projectRegisterService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)projectRegisterEntities)) {
            res.put("exist", (Object)true);
            this.logger.info("\u4f01\u4e1a\u5fae\u4fe1\u548c\u9489\u9489\u7b2c\u4e09\u65b9\u5e94\u7528\u521d\u59cb\u5316\u65f6\u5019\uff0c\u751f\u6210\u9ed8\u8ba4\u9879\u76ee===>> \u6709\u9879\u76ee\uff0c\u4e0d\u65b0\u589e,body={} ", (Object)body);
            return CommonResponse.success((Object)res);
        }
        res.put("exist", (Object)false);
        ProjectRegisterEntity entity = new ProjectRegisterEntity();
        entity.setCode("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(3000000))));
        entity.setName("\u6211\u7684\u7b2c\u4e00\u4e2a\u9879\u76ee");
        entity.setShortName("\u6211\u7684\u7b2c\u4e00\u4e2a\u9879\u76ee");
        entity.setId(IdWorker.getId());
        entity.setTenantId(body.getLong("tenantId"));
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        projectDepartment.setCode("INIT" + projectDepartment.getId());
        projectDepartment.setParentId(body.getLong("orgId"));
        projectDepartment.setTenantId(body.getLong("tenantId"));
        projectDepartment.setEnterpriseId(body.getLong("enterpriseId"));
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(entity.getName());
        projectDepartment.setShortName(entity.getName());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setProjectState(Integer.valueOf(1));
        projectDepartment.setProjectCode(entity.getCode());
        projectDepartment.setNote("\u7cfb\u7edf\u521b\u5efa");
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        entity.setProjectDepartmentId(projectDepartment.getId());
        entity.setCreateUserName("\u7cfb\u7edf\u521b\u5efa");
        entity.setValidStatus("0");
        entity.setStatus("2");
        entity.setSignDate(new Date());
        entity.setType("1");
        entity.setOrgName(body.getString("orgName"));
        entity.setOrgId(body.getLong("orgId"));
        this.projectRegisterService.saveOrUpdateNoES((Object)entity);
        res.put("orgDeptInfo", (Object)projectDepartment);
        return CommonResponse.success((Object)res);
    }

    public static void main(String[] args) {
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(3000000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
        System.out.println("INIT-PRO-" + DateFormatUtil.formatDate((String)"yyyyMMddHHmmsss", (long)(System.currentTimeMillis() + (long)random.nextInt(300000))));
    }

    class Rule {
        private String type;
        private String pattern;
        private String message;

        public Rule(String type, String pattern, String message) {
            this.type = type;
            this.pattern = pattern;
            this.message = message;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

