package com.ejianc.business.market.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/zjkj/projectApi/")
public class ZjkjProjectApi {

    @Autowired
    private IProjectRegisterService projectService;
    @Autowired
	private IOrgApi orgApi;

	/**
	 * 根据项目Id查询项目信息
	 *
	 * @param id
	 * @return
	 */
	@GetMapping("queryDetailById")
	public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id) {
		ProjectRegisterEntity entity = projectService.selectById(id);
		ProjectVO vo = this.getProjectVO(BeanMapper.map(entity, ProjectRegisterVO.class));
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "queryProjectArray")
	public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids){
//		List<ProjectRegisterVO> vos = new ArrayList<>();
		QueryWrapper<ProjectRegisterEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.in("id", ids);
		List<ProjectRegisterEntity> entitys = projectService.list(queryWrapper);
//		if(entitys!=null){
//			vos = BeanMapper.mapList(entitys, ProjectRegisterVO.class);
//		}
		List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList(entitys, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
	}

	/**
	 * 根据项目部id查询项目信息
	 * @param projectDepartmentId
	 * @return
	 */
	@GetMapping("queryProjectByProjectDepartmentId")
	public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId) {
		ProjectRegisterEntity entity = projectService.selectById(projectDepartmentId);
		if(entity == null){
			QueryParam param = new QueryParam();
			param.getParams().put("project_department_id",new Parameter(QueryParam.EQ,projectDepartmentId));
			List<ProjectRegisterEntity> list = projectService.queryList(param,false);
			if(ListUtil.isNotEmpty(list)){
				entity = list.get(0);
			}
		}
		if(entity == null){
			return CommonResponse.success("查询成功！", null);
		}
		ProjectVO vo = this.getProjectVO(BeanMapper.map(entity, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", vo);
	}

	/**
	 * 查询项目
	 * @return
	 */
	@PostMapping("queryProjects")
	@ResponseBody
	public CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
		List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));

		List<ProjectRegisterEntity> list = projectService.queryList(param);
		List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList(list, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", voList);
	}

	/**
	 * 查询项目
	 * @return
	 */
	@PostMapping("queryArray")
	@ResponseBody
	CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
		List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectRegisterEntity> list = projectService.queryList(param);
		List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList(list, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
	}

	/**
	 * 查询当前组织下所有启用且在建的项目
	 * @param orgId
	 * @return
	 */
	@GetMapping("queryProjectsByOrgId")
	@ResponseBody
	public CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId) {
		List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
		param.getParams().put("valid_status", new Parameter(QueryParam.EQ, 0)); // 启用
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectRegisterEntity> list = projectService.queryList(param);
		List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList(list, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", voList);
	}

	/**
	 * 查询当前组织下所有启用且在建的项目
	 * @param orgId
	 * @return
	 */
	@GetMapping("queryArrayByOrgId")
	@ResponseBody
	CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId) {
		List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
        param.getParams().put("valid_status", new Parameter(QueryParam.EQ, 0)); // 启用
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectRegisterEntity> list = projectService.queryList(param);
		List<ProjectVO> voList = this.getProjectVOS(BeanMapper.mapList(list, ProjectRegisterVO.class));
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
	}

	/**
	 * @Description 参照
//	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/refProjectData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ProjectVO>> refProjectData(
			@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
			String condition, String searchObject, String searchText) {
		QueryParam queryParam = new QueryParam();
		queryParam.setPageSize(pageSize);
		queryParam.setPageIndex(pageNumber);
		queryParam.setSearchText(searchText);
		queryParam.setSearchObject(searchObject);
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = queryParam.getFuzzyFields();
		fuzzyFields.add("code");
		fuzzyFields.add("name");
		fuzzyFields.add("orgName");
		//添加简称项目名称模糊查询
		fuzzyFields.add("shortName");
		fuzzyFields.add("createUserName");
		//只查询启用的项目
		queryParam.getParams().put("validStatus", new Parameter(QueryParam.EQ, '0'));
		//租户过滤
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);

		List<Long> commonOrgIds = new ArrayList<>();
		List<Long> departmentIds = new ArrayList<>();
		Long orgId = InvocationInfoProxy.getOrgId();
		Boolean tenantLeave = false;
		/** 移动端参照标识 */
		Boolean mobileLeave = false;

		if (StringUtils.isNotBlank(condition)) {
			Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

			if (null != conditionMap.get("orgId")) {
				orgId = Long.valueOf(conditionMap.get("orgId").toString());
			}
			if (null != conditionMap.get("tenantLeave")) {
				//租户级别数据
				tenantLeave = true;
			}
			if (null != conditionMap.get("mobileLeave")) {
				//移动端数据
				mobileLeave = true;
			}

			if (null != conditionMap.get("province")) {
				queryParam.getParams().put("province", new Parameter(QueryParam.EQ, conditionMap.get("province")));
			}
			if (null != conditionMap.get("city")) {
				queryParam.getParams().put("city", new Parameter(QueryParam.EQ, conditionMap.get("city")));
			}
			if (null != conditionMap.get("region")) {
				queryParam.getParams().put("region", new Parameter(QueryParam.EQ, conditionMap.get("region")));
			}
			// 不包含这个项目
			if (null != conditionMap.get("projectId")) {
				queryParam.getParams().put("id", new Parameter(QueryParam.NE, conditionMap.get("projectId")));
			}
		}

		if (mobileLeave) {
			//移动端
			CommonResponse<List<OrgVO>> response = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
			if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
				queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, response.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
			} else {
				IPage<ProjectVO> pageData = new Page<>(pageNumber, pageSize, 0);
				return CommonResponse.success("该用户没有任何项目权限！", pageData);
			}

		} else if (!tenantLeave) {
			//组织本下
			CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
			if (!orgListResp.isSuccess()) {
				IPage<ProjectVO> pageData = new Page<>(pageNumber, pageSize, 0);
				return CommonResponse.success("查询数表参照失败，项目组织信息查询失败！", pageData);
			}
			List<OrgVO> orgList = orgListResp.getData();

			if (CollectionUtils.isNotEmpty(orgList)) {
				orgList.forEach(orgVO -> {
					if (5 == orgVO.getOrgType()) {
						//项目部
						departmentIds.add(orgVO.getId());
					} else {
						//普通组织
						commonOrgIds.add(orgVO.getId());
					}
				});
				if (CollectionUtils.isNotEmpty(commonOrgIds)) {
					queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
				} else if (CollectionUtils.isNotEmpty(departmentIds)) {
					queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ, departmentIds.get(0)));
				}
			}
		}

		IPage<ProjectRegisterEntity> page = projectService.queryPage(queryParam,false);
		IPage<ProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(this.getProjectVOS(BeanMapper.mapList(page.getRecords(), ProjectRegisterVO.class)));
		return CommonResponse.success("查询参照数据成功！",pageData);
	}

	public ProjectVO getProjectVO(ProjectRegisterVO vo){
		ProjectVO map = BeanMapper.map(vo, ProjectVO.class);
		map.setProjectName(vo.getName());
		map.setBillCode(vo.getCode());
		map.setLeader(vo.getProjectManager());
		map.setStartDate(vo.getPlannedCommencementDate());
		map.setEndDate(vo.getPlannedFinishDate());
		map.setContractualModel(vo.getEngineeringType());
		return map;
	}

	public List<ProjectVO> getProjectVOS(List<ProjectRegisterVO> vos){
		List<ProjectVO> list = new ArrayList<>();
		for (ProjectRegisterVO vo : vos){
			ProjectVO projectVO = this.getProjectVO(vo);
			list.add(projectVO);
		}
		return list;
	}
}