/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="businessOpportunity")
public class BusinessOpportunityBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBusinessOpportunityService businessOpportunityService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BusinessOpportunityEntity entity = (BusinessOpportunityEntity)((Object)this.businessOpportunityService.selectById(billId));
        if (StringUtils.isNotBlank((CharSequence)entity.getFollowPerson())) {
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            String[] receivers = entity.getFollowPerson().split(",");
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject("\u5546\u673a\u767b\u8bb0\u751f\u6548\u63d0\u9192");
            parameter.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u4e2a\u9879\u76ee\uff08" + entity.getEngineeringName() + "\uff09\u9700\u8981\u62a5\u540d");
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BusinessOpportunityEntity entity = (BusinessOpportunityEntity)((Object)this.businessOpportunityService.selectById(billId));
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, entity.getId());
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u4e2d\u6807\u7ed3\u679c\u5206\u6790\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

