/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.mapper.BusinessOpportunityMapper;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessOpportunityServiceImpl
extends BaseServiceImpl<BusinessOpportunityMapper, BusinessOpportunityEntity>
implements IBusinessOpportunityService {
    private static final String BUSINESS_OPPORTUNITY_BILL_CODE = "BT200512000000001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    BusinessOpportunityMapper mapper;

    @Override
    public BusinessOpportunityEntity insertOrUpdate(BusinessOpportunityEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BUSINESS_OPPORTUNITY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdateNoES((Object)entity);
        return entity;
    }

    @Override
    public BusinessOpportunityEntity queryDetail(Long id) {
        return (BusinessOpportunityEntity)((Object)this.selectById(id));
    }

    @Override
    public List<BusinessOpportunityExportVO> queryExportList(QueryParam param) {
        ArrayList<BusinessOpportunityExportVO> resVos = new ArrayList<BusinessOpportunityExportVO>();
        IPage page = super.queryPage(param, false);
        if (page.getTotal() > 0L) {
            page.getRecords().forEach(entity -> {
                BusinessOpportunityExportVO vo = (BusinessOpportunityExportVO)BeanMapper.map((Object)entity, BusinessOpportunityExportVO.class);
                if (entity.getEstimatedBiddingDate() != null) {
                    vo.setEstimatedBiddingDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getEstimatedBiddingDate()));
                }
                resVos.add(vo);
            });
        }
        return resVos;
    }

    @Override
    public BusinessOpportunityEntity selectByProjectId(Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_set_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return (BusinessOpportunityEntity)((Object)super.getOne((Wrapper)query));
    }
}

