/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.SynchroDataParam;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sync/project/"})
public class SynchroDataController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IThirdSystemApi thirdSystemApi;

    @PostMapping(value={"baseInfo"})
    public CommonResponse<String> syncProject(@RequestBody SynchroDataParam data) {
        this.logger.info("\u6536\u5230\u5f85\u540c\u6b65\u9879\u76ee\u90e8\u4fe1\u606f\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)data));
        ProjectRegisterVO project = this.transToProjectVO(data);
        switch (data.getSyncType()) {
            case 1: 
            case 2: {
                this.projectRegisterService.saveSyncProject(project);
                break;
            }
            case 3: {
                this.projectRegisterService.changeValidStatus(project);
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u6210\u529f\uff01");
    }

    private ProjectRegisterVO transToProjectVO(SynchroDataParam project) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        Integer[] typeArr = new Integer[]{1, 2, 3};
        boolean materialVerification = false;
        if (StringUtils.isBlank((CharSequence)project.getId())) {
            this.logger.error("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u4e1a\u52a1\u4e3b\u952e\u3010id\u3011\u4e3a\u7a7a\u3002");
            throw new BusinessException("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u4e1a\u52a1\u4e3b\u952e\u3010id\u3011\u4e3a\u7a7a\u3002");
        }
        if (!Arrays.asList(typeArr).contains(project.getSyncType())) {
            this.logger.error("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u7684\u540c\u6b65\u7c7b\u578b\u3010syncType: {}\u3011", (Object)project.getSyncType());
            throw new BusinessException("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u7684\u540c\u6b65\u7c7b\u578b\u3010syncType: " + project.getSyncType() + "\u3011");
        }
        if (StringUtils.isBlank((CharSequence)project.getSystemCode())) {
            this.logger.error("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u6765\u6e90\u7cfb\u7edf\u7f16\u7801\u3010systemCode\u3011\u4e3a\u7a7a");
            throw new BusinessException("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u6765\u6e90\u7cfb\u7edf\u7f16\u7801\u3010systemCode\u3011\u4e3a\u7a7a");
        }
        CommonResponse thirdSystemResp = this.thirdSystemApi.getOneByCode(project.getSystemCode());
        if (!thirdSystemResp.isSuccess()) {
            this.logger.error("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u7f16\u7801\u3010systemCode: {}\u3011\u5bf9\u5e94\u7684\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25\u3002", (Object)project.getSystemCode());
            throw new BusinessException("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u7f16\u7801\u3010systemCode: " + project.getSystemCode() + "\u3011\u5bf9\u5e94\u7684\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ThirdSystemVO system = (ThirdSystemVO)thirdSystemResp.getData();
        if (null == system) {
            this.logger.error("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u7f16\u7801\u3010systemCode: {}\u3011\u65e0\u5339\u914d\u7684\u7cfb\u7edf\u4fe1\u606f\u3002", (Object)project.getSystemCode());
            throw new BusinessException("\u540c\u6b65\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u7f16\u7801\u3010systemCode: " + project.getSystemCode() + "\u3011\u65e0\u5339\u914d\u7684\u7cfb\u7edf\u4fe1\u606f\u3002");
        }
        vo.setTenantId(system.getTenantId());
        vo.setSystemCode(system.getCode());
        vo.setSystemId(system.getId());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)project.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)vo.getTenantId());
        ProjectRegisterEntity dbEntity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)query));
        if (3 != project.getSyncType()) {
            if ("1".equals(project.getType())) {
                materialVerification = true;
            }
            project.setType("1");
            if (StringUtils.isBlank((CharSequence)project.getName())) {
                this.logger.error("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a\u3010name\u3011\u4e3a\u7a7a");
                throw new BusinessException("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a\u3010name\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)project.getOrgId())) {
                this.logger.error("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7Id\u3010orgId\u3011\u4e3a\u7a7a\u3002");
                throw new BusinessException("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7Id\u3010orgId\u3011\u4e3a\u7a7a\u3002");
            }
            CommonResponse orgResp = this.orgApi.findBySourceId(project.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25\u6216\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002");
                throw new BusinessException("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25\u6216\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002");
            }
            OrgVO org = (OrgVO)orgResp.getData();
            if (null == dbEntity && 2 == project.getSyncType()) {
                this.logger.info("\u670d\u52a1\u8c03\u7528\u65b9\u5f0f\u4e3a\u66f4\u65b0\uff0c\u4f46\u662f\u8be5\u9879\u76ee\u4fe1\u606f\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u5c06\u670d\u52a1\u65b9\u5f0f\u6539\u4e3a\u65b0\u589e\uff01");
                project.setSyncType(Integer.valueOf(1));
            } else if (null != dbEntity) {
                vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)dbEntity), ProjectRegisterVO.class);
                vo.setTenantId(system.getTenantId());
                vo.setSystemCode(system.getCode());
                vo.setSystemId(system.getId());
            }
            vo.setOrgName(org.getName());
            vo.setOrgId(org.getId());
            vo.setName(project.getName());
            vo.setType(project.getType());
            vo.setSourceId(project.getId());
            vo.setMaterialVerification(Boolean.valueOf(materialVerification));
            if (StringUtils.isNotBlank((CharSequence)project.getCode())) {
                vo.setCode(project.getCode());
            }
            if (null != dbEntity && !dbEntity.getCode().equals(vo.getCode()) && this.projectRegisterService.codeUsedCheck(vo)) {
                this.logger.error("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u7f16\u7801\u91cd\u590d\u3002");
                throw new BusinessException("\u9879\u76ee\u540c\u6b65\u5931\u8d25\uff0c\u9879\u76ee\u7f16\u7801\u91cd\u590d\u3002");
            }
        } else {
            if (null == dbEntity) {
                this.logger.error("\u9879\u76ee\u505c\u7528\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u9879\u76ee[sourceId-{},code-{}]\u3002", (Object)project.getId(), (Object)project.getCode());
                throw new BusinessException("\u9879\u76ee\u505c\u7528\u5931\u8d25\uff0c\u9879\u76ee\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            }
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)dbEntity), ProjectRegisterVO.class);
            vo.setValidStatus("1");
        }
        return vo;
    }
}

