package com.ejianc.business.market.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目登记
 */
@TableName("ejc_market_project")
public class ProjectRegisterEntity extends BaseEntity {

    private static final long serialVersionUID = -7103485558232569473L;

    /**
     * 项目编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 项目名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部Id
     */
    @TableField(value = "project_department_id")
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    @TableField(value = "status")
    private String status;

    /**
     * 项目状态：0-启用，1-停用
     */
    @TableField(value = "valid_status")
    private String validStatus;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField(value = "type")
    private String type;

    /**
     * 管理费: 联营时展示，自营时不展示
     *
     */
    @TableField(value = "manage_charge_ratio")
    private Double manageChargeRatio;

    /**
     * 承包模式
     * 1-施工总承包，2-工程总承包，3-EPC承包，4-精细化分包，5-扩大劳务分包，6-其他
     *
     */
    @TableField(value = "contractual_model")
    private Long contractualModel;

    /**
     * 发包单位
     */
    @TableField(value = "pub_unit")
    private Long pubUnit;

    /**
     * 承包单位
     */
    @TableField(value = "contractor_unit")
    private Long contractorUnit;

    /**
     * 项目地区
     */
    @TableField(value = "area")
    private String area;

    /**
     * 详细地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 投资主体
     */
    @TableField(value = "investor")
    private Long investor;

    /**
     * 资金来源
     */
    @TableField(value = "funds_source")
    private String fundsSource;

    /**
     * 总造价(万元)
     */
    @TableField(value = "cost_total")
    private BigDecimal costTotal;

    /**
     * 招标形式
     */
    @TableField(value = "bidding_from")
    private Long biddingForm;


    /**
     * 计划开工日期
     */
    @TableField(value = "planned_commencement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;

    /**
     * 计划竣工日期
     */
    @TableField(value = "planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 建筑面积(㎡)
     */
    @TableField(value = "built_area")
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    @TableField(value = "structure_type")
    private Long structureType;

    /**
     * 工程用途
     */
    @TableField(value = "engineering_purpose")
    private Long engineeringPurpose;

    /**
     * 工程概况
     */
    @TableField(value = "project_overview")
    private String projectOverview;

    /**
     * 冗余所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 冗余承包单位名称
     */
    @TableField(value = "contractor_unit_name")
    private String contractorUnitName;

    /**
     * 冗余发包单位名称
     */
    @TableField(value = "pub_unit_name")
    private String pubUnitName;

    /**
     * 承包模式
     */
    @TableField(value = "contractual_model_name")
    private String contractualModelName;

    /**
     * 投资主体
     */
    @TableField(value = "investor_name")
    private String investorName;

    /**
     * 招标形式
     */
    @TableField(value = "bidding_form_name")
    private String biddingFormName;

    /**
     * 结构类型
     */
    @TableField(value = "structure_type_name")
    private String structureTypeName;
    /**
     * 工程用途
     */
    @TableField("engineering_purpose_name")
    private String engineeringPurposeName;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    @TableField(value = "source_id")
    private String sourceId;
    /**
     * 数据来源系统Id
     */
    @TableField(value = "system_id")
    private String systemId;

    /**
     * 签订日期
     */
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 项目经理
     */
    @TableField(value = "project_manager")
    private Long projectManager;

    /**
     * 项目经理名称
     */
    @TableField(value = "project_manager_name")
    private String projectManagerName;

    /**
     * 工程类型
     */
    @TableField(value = "engineering_type")
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    @TableField(value = "engineering_type_name")
    private String engineeringTypeName;

    /**
     * 省份
     */
    @TableField(value = "province")
    private String province;

    /**
     * 市区
     */
    @TableField(value = "city")
    private String city;

    /**
     * 区县
     */
    @TableField(value = "region")
    private String region;

    /**
     * 是否使用材料核销
     */
    @TableField(value = "material_verification")
    private Boolean materialVerification;

    /**
     * 关注类型 0-普通项目 1-工程局重点关注 2-工程局重点监控 3-二级单位重点关注 4-二级单位重点监控
     */
    @TableField(value = "focus_type")
    private String focusType;

    @TableField(value="area_id")
    private Long areaId; // 区域id
    @TableField(value="area_code")
    private String areaCode; // 区域编码
    @TableField(value="area_name")
    private String areaName; // 区域名称

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getFocusType() {
        return focusType;
    }

    public void setFocusType(String focusType) {
        this.focusType = focusType;
    }

    public Boolean getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Boolean materialVerification) {
        this.materialVerification = materialVerification;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getManageChargeRatio() {
        return manageChargeRatio;
    }

    public void setManageChargeRatio(Double manageChargeRatio) {
        this.manageChargeRatio = manageChargeRatio;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}
