package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.mapper.BusinessOpportunityMapper;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class BusinessOpportunityServiceImpl extends BaseServiceImpl<BusinessOpportunityMapper, BusinessOpportunityEntity> implements IBusinessOpportunityService {
    private static final String BUSINESS_OPPORTUNITY_BILL_CODE = "BT200512000000001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    BusinessOpportunityMapper mapper;
    @Override
    public BusinessOpportunityEntity insertOrUpdate(BusinessOpportunityEntity entity){
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BUSINESS_OPPORTUNITY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity);
        return entity;
    }

    @Override
    public BusinessOpportunityEntity queryDetail(Long id){
        return super.selectById(id);
    }

    @Override
    public List<BusinessOpportunityExportVO> queryExportList(QueryParam param) {
        List<BusinessOpportunityExportVO> resVos = new ArrayList<>();
        IPage<BusinessOpportunityEntity> page = super.queryPage(param,false);
        if(page.getTotal()>0){
            page.getRecords().forEach(entity->{
                BusinessOpportunityExportVO vo = BeanMapper.map(entity, BusinessOpportunityExportVO.class);
                if(entity.getEstimatedBiddingDate() !=null ){
                    vo.setEstimatedBiddingDate(DateFormatUtil.formatDate("yyyy-MM-dd",entity.getEstimatedBiddingDate()));
                }
                resVos.add(vo);
            });
        }
        return resVos;
    }

    @Override
    public BusinessOpportunityEntity selectByProjectId(Long projectId) {
        QueryWrapper<BusinessOpportunityEntity> query = new QueryWrapper<>();
        query.eq("project_set_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.getOne(query);
    }
}
