package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.PlanIndexEntity;
import com.ejianc.business.market.bean.ProjectBiddingEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.business.market.vo.BusinessOpportunityVO;
import com.ejianc.business.market.vo.PlanIndexVO;
import com.ejianc.business.market.vo.ProjectBiddingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import org.apache.commons.collections.CollectionUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2020/5/12
 * @Description BusinessOpportunityController
 */

@Controller
@RequestMapping("/business/opportunity/")
public class BusinessOpportunityController  implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    IBusinessOpportunityService iBusinessOpportunityService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired private SessionManager sessionManager;
    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 新增或者修改
     * @param businessOpportunityVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> saveOrUpdate(@RequestBody BusinessOpportunityVO businessOpportunityVO) {
    	BusinessOpportunityEntity entity = BeanMapper.map(businessOpportunityVO, BusinessOpportunityEntity.class);
    	BusinessOpportunityEntity backEntity = iBusinessOpportunityService.insertOrUpdate(entity);
    	BusinessOpportunityVO vo = BeanMapper.map(backEntity, BusinessOpportunityVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> update(@RequestBody BusinessOpportunityVO businessOpportunityVO) {

     /*   LambdaUpdateWrapper<BusinessOpportunityEntity> updateWrapper=new LambdaUpdateWrapper<>();
        updateWrapper.set(BusinessOpportunityEntity::getBusinessState,businessOpportunityVO.getBusinessState());
        updateWrapper.set(BusinessOpportunityEntity::getStateMemo,businessOpportunityVO.getStateMemo());
        updateWrapper.eq(BusinessOpportunityEntity::getId,businessOpportunityVO.getId());
        boolean flag = iBusinessOpportunityService.update(updateWrapper);
        if(!flag){
            throw new BusinessException("项目状态更新失败！");
        }
        BusinessOpportunityEntity entity = iBusinessOpportunityService.queryDetail(businessOpportunityVO.getId());
        BusinessOpportunityVO vo = BeanMapper.map(entity, BusinessOpportunityVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);*/
        BusinessOpportunityEntity entity = BeanMapper.map(businessOpportunityVO, BusinessOpportunityEntity.class);
        entity.setBillState(1);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        BusinessOpportunityEntity backEntity = iBusinessOpportunityService.insertOrUpdate(entity);
        BusinessOpportunityVO vo = BeanMapper.map(backEntity, BusinessOpportunityVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> queryDetail(Long id) {
    	BusinessOpportunityEntity entity = iBusinessOpportunityService.queryDetail(id);
    	BusinessOpportunityVO vo = BeanMapper.map(entity, BusinessOpportunityVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("BusinessOpportunity",iBusinessOpportunityService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityEntity>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("followPersonPhone");
        fuzzyFields.add("constructionUnitName");
        fuzzyFields.add("engineeringStageName");
        fuzzyFields.add("provincesName");
        fuzzyFields.add("biddingFormName");
        fuzzyFields.add("estimatedBiddingDate");
        fuzzyFields.add("costTotal");
        fuzzyFields.add("projectIsSet");
        fuzzyFields.add("billState");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("查询列表数据成功！",iBusinessOpportunityService.queryPage(param,false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/5/20
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessOpportunityVO> vos) {
        iBusinessOpportunityService.removeByIds(vos.stream().map(BusinessOpportunityVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<BusinessOpportunityExportVO> supplierVos = iBusinessOpportunityService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("business-opportunity-export.xlsx", beans, response);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/5/22
     * @Description refer 商机登记列表参照
     *
     * @Param [pageNumber, pageSize, searchText]
     * @Return com.alibaba.fastjson.JSONObject
     */
    @RequestMapping(value = "/refer")
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityVO>> refer(@RequestParam(defaultValue = "1") Integer pageNumber,
                            @RequestParam(defaultValue = "10") Integer pageSize,
                            String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        //** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 *//*
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            //** 要求主表有orgId字段，保存单据所属组织 *//*
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            //** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        //** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ *//*
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("project_is_set", new Parameter(QueryParam.EQ, null));

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("project_is_set", new Parameter(QueryParam.EQ, false));

        c1.getComplexParams().add(c2);
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);

        IPage<BusinessOpportunityEntity> pageData = iBusinessOpportunityService.queryPage(queryParam,false);
        IPage<BusinessOpportunityVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), BusinessOpportunityVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
