package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.bean.ResultAnalysisEntity;
import com.ejianc.business.market.service.IResultAnalysisService;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("resultAnalysis") 
public class ResultAnalysisBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IResultAnalysisService resultAnalysisService;
	@Autowired
	private IBusinessOpportunityService businessOpportunityService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ResultAnalysisEntity resultAnalysisEntity = resultAnalysisService.selectById(billId);
		Long oppId = resultAnalysisEntity.getOppId();
		Integer isWinInfo = resultAnalysisEntity.getIsWinInfo();
		UpdateWrapper<BusinessOpportunityEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.set("result_state",isWinInfo);
		updateWrapper.eq("id",oppId);
		businessOpportunityService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ResultAnalysisEntity entity = resultAnalysisService.selectById(billId);
		BusinessOpportunityEntity buOpr = businessOpportunityService.queryDetail(entity.getOppId());
		if(null != buOpr.getProjectIsSet() && buOpr.getProjectIsSet()) {
			return CommonResponse.error("已经被项目立项使用,不能弃审和撤回");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ResultAnalysisEntity resultAnalysisEntity = resultAnalysisService.selectById(billId);
		Long oppId = resultAnalysisEntity.getOppId();
		UpdateWrapper<BusinessOpportunityEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.set("result_state",0);
		updateWrapper.eq("id",oppId);
		businessOpportunityService.update(updateWrapper);
		return CommonResponse.success();
	}

}
